<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use App\Models\JobRequests;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;

class JobRequestExport implements FromArray,ShouldAutoSize, WithEvents {


    public function  __construct($data)
    {
        $this->data= $data;
      

    }

    private $shouldBeRedNum = [1,2,3,4,5,6,7,8,9,10,11];


    public function array(): array
    {
        
        
              $top_heading_content="Job Requests Report";
              if(session('from_date')){
            if(session('to_date')){
                
                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $to_date = date("d-m-Y", strtotime(session('to_date')));
                
                $top_heading_content=$top_heading_content.'   From:'.$from_date.'   To:'.$to_date;
           
            }
            else{
                $from_date = date("d-m-Y", strtotime(session('from_date')));
              $top_heading_content=$top_heading_content.'   Date:'.$from_date;
            }
            
        }
        

      $top_heading=[$top_heading_content];
       $columns[0]=$top_heading;
       
       
       
      

      $heading = [
        '#.',
        'Phone',
        'Location',
        'Villa Appartment No.',
        'Room Name',
        'Maintenance Type',
        'Sub - Maintenance Type',
        'Staff Assigned',

      ];
 
      $propertyArray = [];

    $columns[1]=$heading;
    
    $j=2;
    $i=1;
    foreach($this->data['report_data'] as $datas){
    
    
    
    
    $order_data = [
            $i,
            $datas['ph_no'],
            $datas['location'],
            $datas['villa_appartment'],
            $datas['room_name'],
            $datas['maintenance_type'],
            $datas['maintanance_sub'],
            $datas['emp_name'],
          ];
        $columns[$j]=$order_data;
        $j++;
        $i++;
}


      return [$columns] ; 
    }
   
    public function registerEvents(): array
    {
      $shouldBeRedNumTransformed = $this->shouldBeRedNum;
      foreach ($shouldBeRedNumTransformed as $key => $index) {
        $shouldBeRedNumTransformed[$key] = $this->getNameFromNumber($index);
      }
      

      return [
        AfterSheet::class => function (AfterSheet $event) use($shouldBeRedNumTransformed){
          $event->sheet->getStyle('A1:AZ1')->applyFromArray(['font' => ['bold' => true]]);
          $event->sheet->getDelegate()->mergeCells('A1:H1');
          
          
          
          
        //   foreach ($shouldBeRedNumTransformed as $key => $cellNo) {
            $event->sheet
            ->getStyle('A1:H1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('19990C');
            
         $event->sheet->getDelegate()->getStyle('A1:AZ1')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        
         $event->sheet->getDelegate()->getStyle('C')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                                
                                
                                
         $event->sheet->getDelegate()->getStyle('D')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                                
         $event->sheet->getDelegate()->getStyle('E')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                                
                    
         $event->sheet->getDelegate()->getStyle('F')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
        $event->sheet->getDelegate()->getStyle('G')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
        $event->sheet->getDelegate()->getStyle('H')
                                ->getAlignment()
                                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            
            
            
            
        //   }
        }
      ];
    }

    private function getNameFromNumber($num) {
      $numeric = ($num - 1) % 26;
      $letter = chr(65 + $numeric);
      $num2 = intval(($num - 1) / 26);
     
      if ($num2 > 0) {
        return $this->getNameFromNumber($num2).$letter ;  
      } else {
        return $letter;
      }
    }
}