<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use App\Models\Chat_bot_user;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Hash;
use App\Models\formModel;
use App\Models\formdataModel;
use App\Models\languageModel;
use Spatie\Permission\Models\Role;
use App\Models\notificationModel;
use App\Models\customerModel;
use App\Models\JobRequests;
use DB;


class chatbotController extends BaseController
{

  public function save_chatbot_user_details(Request $request)
  {
        $rule = [
            'name'   => 'required|string',
            'number' => 'required',
            'location' => 'required|string',
            'villa_appartment' => 'required',
            'room_name' => 'required',
            'maintenance_type' => 'required',
            'maintanance_sub' => 'required',
            'issue_details' => 'required',
        ];
        \Log::info($request);
        $validator = Validator::make($request->all(), $rule);
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $data = [
          'name' => $request->name,
          'ph_no' => $request->number,
          'location' => $request->location,
          'villa_appartment' => $request->villa_appartment,
          'maintanance_sub' => $request->maintanance_sub,
          'room_name' => $request->room_name,
          'maintenance_type' => $request->maintenance_type,
          'issue_details' => $request->issue_details,
        ];
        $user = JobRequests::create($data);
        return response()->json($user, 201);
  }
 

public function get_form_data(Request $request){
    
   $language=$request->language;
   $form_page_number=$request->form_page_number;
    //en,ar,
   $get_language_details=  languageModel::where('language_status', 0)->where('language_active_status', 0)->where('language_permalink', $language)->first();
   
    $language_id=$get_language_details->language_id;
    
    $get_form_data=formModel::where('form_status',0)->where('form_active_status',0)->where('form_language',$language_id)->orderby('showing_order','asc')->get()->toArray();
    
     $total_array=array(); 
     $question_number=1;
    foreach($get_form_data as $form_data){
        
        
        

                    
        foreach(json_decode($form_data['form_data']) as $questions){
            
            $question_data=['question_number'=>$question_number,'question'=>$questions->label,'type'=>$questions->type];
            
            

            
    $type=$questions->type;
    switch ($type) {
    case "checkbox-group":
       $options=$questions->values;
       $question_data['options']=$options;
    break;
    case "select":
      $options=$questions->values;
      $question_data['options']=$options;
    break;
    case "radio-group":
      $options=$questions->values;
      $question_data['options']=$options;
    break;

    default:
       
    break;
}

          array_push($total_array,$question_data);
          $question_number++;
            
        }
        
        
        
    }
    return response()->json($total_array);

    
    
}

public function save_form_data(Request $request){
    
    $question_answers=$request->question_answers;

    $language=$request->language;
    
    // foreach($question_answers as $key =>$answer){
       
    // }
    
    
       $get_language_details=  languageModel::where('language_status', 0)->where('language_active_status', 0)->where('language_permalink', $language)->first();
   
    $language_id=$get_language_details->language_id;
    
    $get_form_data=formModel::where('form_status',0)->where('form_active_status',0)->where('form_language',$language_id)->orderby('showing_order','asc')->get()->toArray();
    
        $total_array=array(); 
        foreach($get_form_data as $form_data){
        foreach(json_decode($form_data['form_data']) as $questions){
         array_push($total_array,$questions);
        
        }
    }    
    
    
    $data=$this->add_answer_data($question_answers,$total_array);
    //Form Data
    $form_data=[$data['total_array']];
    $form_data=json_encode($form_data);

    //rating_data
    $rating=$data['rating'];
    //Check Customer Data Exist
    $customer_id="";
    if($data['customer_name'] && $data['customer_email'] && $data['customer_mobile']){
        $customer_id=$this->add_to_customer($data['customer_name'],$data['customer_email'],$data['customer_mobile']);
    }
    


      $formdata_submit = new formdataModel();
      $formdata_submit->form_data_ip = '';
      $formdata_submit->form_data_status = 0;
      $formdata_submit->form_data_seen_status = 0;
      $formdata_submit->form_data = $form_data;
      $formdata_submit->form_rating = $rating;
      $formdata_submit->form_customer_id = $customer_id;
      $formdata_submit->form_date = date('Y-m-d');
      $formdata_submit->form_time = date('H:i');
      $formdata_submit->form_data_unique_id = $this->sku_generate();
      $formdata_submit->save();
      $this->set_notificaton();
      
      dd("Success");
      
      

}

public function add_answer_data($question_answers,$total_array){
    $i=0;
    // dd($total_array);
    $data['rating']="";
    $data['customer_name']="";
    $data['customer_email']="";
    $data['customer_mobile']="";
    $data['rating']="";
    
    foreach($question_answers as $question_answer){
        $answer_array[0]=$question_answer;
        $total_array[$i]->userData=$answer_array;
        
        //Get Rating Data
       
        
        if($total_array[$i]->type=="checkbox-group" && $total_array[$i]->other=="rating" ){
          $data['rating']=$answer_array[0];
        }
        
        //Get Customer_Name
        elseif ($total_array[$i]->type == "text" && $total_array[$i]->other == "Name") {
           $data['customer_name']=$answer_array[0];
           
         }
         //Get Customer Mobile
         elseif ($total_array[$i]->type == "text" && $total_array[$i]->subtype == "tel") {
           $data['customer_mobile']=$answer_array[0];
         }
         //Get Customer Email
         elseif ($total_array[$i]->type == "text" && $total_array[$i]->subtype == "email") {
           $data['customer_email']=$answer_array[0];
           
         }
    
       // $total_array[$i]=json_encode($total_array[$i]);
        $total_array[$i]=$total_array[$i];
        $i++;
    }
    

    $data['total_array']=json_encode($total_array);
   return $data;
}

  public function sku_generate()
  {
    $last_form_data = formdataModel::orderby('form_data_id', 'DESC')->first();
    if ($last_form_data) {
      $lastunique_id = $last_form_data->form_data_unique_id;
      $newdata = substr($lastunique_id, -6);
      $newUniq = 'CUSRW' . sprintf('%06d', ($newdata + 1));
    } else {
      $newUniq = 'CUSRW' . sprintf('%06d', 1);
    }
    return $newUniq;
  }
  
  
      public function add_to_customer($customer_name,$customer_email,$customer_mobile){
        
       try{
          
           //Check Customer Already Exist With Same Name,email,Mobile
        $check_customer_exist= customerModel::where('customer_status',0)
        ->where('customer_name',$customer_name)
        ->where('customer_mob',$customer_mobile)
        ->where('customer_mail_id',$customer_email)
        ->first();
    
        if($check_customer_exist){
            $customer_id=$check_customer_exist->customer_id;
        }
        else{
        $unique_id = $this->sku_generate_customer_id();
        $customer = new customerModel();
        $customer->customer_ip = "";
        $customer->customer_status = 0;
        $customer->customer_unique_id = $unique_id;
        $customer->customer_name = $customer_name;
        $customer->customer_mob = $customer_mobile;
        $customer->customer_mail_id = $customer_email;
        $customer->customer_address = "";
        $customer->created_by = 1;
        $customer->updated_by = 1;
        $customer->save();
        $customer_id=$customer->id;
        }
        return $customer_id;
           
       }
       catch (Exception $e) {
      $message = $e->getMessage();
      return $message;
      }
        
    }
    
            public function sku_generate_customer_id()
    {
        $lastcustomer = customerModel::orderby('customer_id', 'DESC')->first();
        if ($lastcustomer) {
            $lastcustomer = $lastcustomer->customer_unique_id;
            $newdata = substr($lastcustomer, -4);
            $newUniq = 'RAC' . sprintf('%04d', ($newdata + 1));
        } else {
            $newUniq = 'RAC' . sprintf('%04d', 1);
        }
        return $newUniq;
    }
    
    
      public function set_notificaton()
  {
    $notification = new notificationModel();
    $notification->notification_status = 0;
    $notification->notification_seen_status = 0;
    $notification->notification_date = date('Y-m-d');
    $notification->notification_time = date('H:i');
    $notification->notification_branch = 1;
    $notification->notification_type = 1;
    $notification->notification_name = "Feed Back";
    $notification->notification_name = "New Feed Back";
    $notification->notification_desc = "You Have A  New Feedback";
    $notification->priviliage = 1;
    $notification->save();


  }
  
  
}
