<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Session;
use App\Models\user;
use App\Models\notificationModel;
use Auth;
use DB;

class Controller extends BaseController
{
    public function __construct()
    {
        ini_set('memory_limit', '88M');
    }


    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public function set_light_mode(Request $request)
    {
        $class_name = $request->class;
        Session::put('light_mode_class_name', $class_name);
    }
    public function set_side_menu_view(Request $request)
    {
        if (session('side_menu_class_name') == "") {
            Session::put('side_menu_class_name', 'sidenav-toggled');
        } else {
            session()->forget('side_menu_class_name');
        }

    }

    public function set_sound_status(Request $request)
    {
        $status = $request->status;
        $update_user = user::where('id', Auth::user()->id)->update(['sound_effect' => $status]);
        return $status;
    }
    public function from_date_filter(Request $request)
    {
        $from_date = $request->from_date;
        Session::put('from_date', $from_date);
    }
    public function to_date_filter(Request $request)
    {
        $to_date = $request->to_date;
        Session::put('to_date', $to_date);

    }

    public function new_notification()
    {
        $new_notification_count = notificationModel::
            where('notification_status', 0)
            ->where('notification_seen_status', 0)
            ->count();

        if (Auth::user()->sound_effect == 1) {
            $sound = "";
        } else {
            $sound = env('APP_URL') . '/assets/sounds/stock_reminder.mp3';
        }


        return $data = ['count' => $new_notification_count, 'sound' => $sound];
    }
    public function update_notification_status()
    {
        $update = DB::table('tbl_admin_notification')->update(['notification_seen_status' => 1]);
        if ($update) {
            return $data = ['status' => 0, 'heading' => 'success', 'msg' => 'Succesfully Updated'];
        }
    }

    public function reset_session()
    {

        $sesion_array = array('from_date', 'to_date', 'user_filter');
        foreach ($sesion_array as $session) {
            Session::forget($session);
        }
        return "Success";
    }


}