<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\JobRequests;
use App\Models\ServiceSectionModel;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Auth;

class JobRequestController extends Controller
{
    
    
        public function __construct()
    {
        ini_set('memory_limit', '88M');
    }

    public function index(){
        $data["employees"] = ServiceSectionModel::where('section_status',0)->get();
        return view('admin.job_requests.index')->with($data);
        }


    public function job_request_datatable(Request $request){
         $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_job_requests.job_id';
        $sort = 'DESC';
      if (isset($order[0]['column']) && isset($order[0]['dir'])) {
          $colNo = $order[0]['column'];
          $sort = $order[0]['dir'];
          if (isset($columns[$colNo]['name'])) {
              $colName = $columns[$colNo]['name'];
          }
      }


        $query_data = JobRequests::leftjoin('tbl_service_section','tbl_job_requests.staff_assigned','tbl_service_section.service_sec_id')
        ->select('tbl_job_requests.*','tbl_service_section.emp_name')
        ->Where(function($query) use ($search) {
            $query->where('name', 'like', $search . '%');
            $query->orwhere('ph_no', 'like', $search . '%');
            $query->orwhere('location', 'like', $search . '%');
            $query->orwhere('villa_appartment', 'like', $search . '%');
            $query->orwhere('maintanance_sub', 'like', $search . '%');
            $query->orwhere('room_name', 'like', $search . '%');
            $query->orwhere('maintenance_type', 'like', $search . '%');
            $query->orwhere('issue_details', 'like', $search . '%');
        });
        if(session('from_date'))
        {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
        if(session('to_date'))
        	{
            $to_date = date("Y-m-d", strtotime(session('to_date')));
        	$query_data->where('tbl_job_requests.created_at','>=',    $from_date);
        	$query_data->where('tbl_job_requests.created_at','<=',$to_date);
        	}
        else
        	{
        	$query_data->where('tbl_job_requests.created_at',$from_date);
        	}
        }
      if ($colName != '' && $sort != '') {
          $query_data->orderBy($colName, $sort);
      }
      else{
         $query_data->orderBy('job_id', 'DESC');
      }
      $data = ['iTotalDisplayRecords' => $query_data->count(), 'iTotalRecords' => $query_data->count(), 'TotalDisplayRecords' => $limit];
      $data['data'] = $query_data->skip($offset)->take($limit)->get()->toArray();
      return response()->json($data);
    }


    public function assign_staff(Request $request)
    {
        JobRequests::where('job_id',$request->job_id_new)->update(['staff_assigned'=>$request->staffs]);
        return back();
    }
    
    
} 
