<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MainServiceModel;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Auth;

class MainServiceController extends Controller
{
    
    
        public function __construct()
    {
        ini_set('memory_limit', '88M');
    }

    public function index(){
        return view('admin.services_main.index');
        }

    public function add_main_service(Request $request){

        
        $validator = Validator::make($request->all(), [
            'service'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        } 
   
   
        $news=new MainServiceModel();
        
        $news->service=$request->service;
        


        $news->created_by=Auth::user()->id;
        $news->updated_by=Auth::user()->id;
        $news->save();
        if($news){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Added";
      $user_activity_log['activity_desc']='New Department '.$request->service.' Has Been Added By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Department added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }


    public function edit_main_services(Request $request){    
      $id=$request->id;
      $data=MainServiceModel::select('*')->where('serv_id',$id)->first();
      return response()->json($data);
    }
    public function update_main_services(Request $request){
      $id=$request->news_id;
        
        $validator = Validator::make($request->all(), [
            'service'=>'required',
        ]);
    if ($validator->fails()) { 
        foreach (array_values($validator->messages()->toArray()) as $msg) {
            $error = implode(' ', $msg).'<br>';
        }
        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
    }
 
 

    $data=[
        'service'=>$request->service,
        'updated_by'=>Auth::user()->id,
    ];

    

        

      $update=MainServiceModel::where('serv_id',$id)->update($data); 
     if($update==1){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Updated";
      $user_activity_log['activity_desc']='Department '.$request->service.' Has Been Updated By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Department updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }
     
    }


    public function delete_main_services(Request $request){
        $id=$request->id;
        $details=MainServiceModel::where('serv_id',$id)->first();
        $update=MainServiceModel::where('serv_id',$id)->update(['service_status'=>1]);
        if($update==1){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Deleted";
      $user_activity_log['activity_desc']='Department '.$details->service.' Has Been Deleted By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Department removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function main_services_datatable(Request $request){
         $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_main_services.serv_id';
        $sort = 'DESC';
      if (isset($order[0]['column']) && isset($order[0]['dir'])) {
          $colNo = $order[0]['column'];
          $sort = $order[0]['dir'];
          if (isset($columns[$colNo]['name'])) {
              $colName = $columns[$colNo]['name'];
          }
      }


        $query_data = MainServiceModel::where('service_status',0)
        ->leftjoin('users','tbl_main_services.created_by','users.id')
        ->select('tbl_main_services.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('service', 'like', $search . '%');
        });
      if ($colName != '' && $sort != '') {
          $query_data->orderBy($colName, $sort);
      }
      else{
         $query_data->orderBy('serv_id', 'DESC');
      }
      $data = ['iTotalDisplayRecords' => $query_data->count(), 'iTotalRecords' => $query_data->count(), 'TotalDisplayRecords' => $limit];
      $data['data'] = $query_data->skip($offset)->take($limit)->get()->toArray();
      return response()->json($data);
    }
    
} 
