<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ServiceSectionModel;
use App\Models\MainServiceModel;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Auth;

class ServiceSectionController extends Controller
{
    
    
        public function __construct()
    {
        ini_set('memory_limit', '88M');
    }

    public function index(){
        $data["services"] = MainServiceModel::where('service_status',0)->get();
        return view('admin.service_section.index')->with($data); 
        }

    public function add_service_sections(Request $request){
        $validator = Validator::make($request->all(), [
            'department'=>'required',
            'name'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'address'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        } 
   
   
        $news=new ServiceSectionModel();
        
        $news->service_id=$request->department;
        $news->emp_name=$request->name;
        $news->emp_email=$request->email;
        $news->emp_phone=$request->phone;
        $news->emp_address=$request->address;
        $news->created_by=Auth::user()->id;
        $news->updated_by=Auth::user()->id;

        

        

        $news->save();
        if($news){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Added";
      $user_activity_log['activity_desc']='New Employee '.$request->service.' Has Been Added By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Employee added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function edit_service_sections(Request $request){    
      $id=$request->id;
      $data=ServiceSectionModel::select('*')->where('service_sec_id',$id)->first();
      return response()->json($data);
    }
    public function update_service_sections(Request $request){
      $id=$request->news_id;
        $validator = Validator::make($request->all(), [
            'department'=>'required',
            'name'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'address'=>'required',
        ]);
    if ($validator->fails()) { 
        foreach (array_values($validator->messages()->toArray()) as $msg) {
            $error = implode(' ', $msg).'<br>';
        }
        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
    }
 
 

    $data=[
        'service_id'=>$request->department,
        'emp_name'=>$request->name,
        'emp_email'=>$request->email,
        'emp_phone'=>$request->phone,
        'emp_address'=>$request->address,
    ];


    
    
        

      $update=ServiceSectionModel::where('service_sec_id',$id)->update($data); 
     if($update==1){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Updated";
      $user_activity_log['activity_desc']='Employee '.$request->service.' Has Been Updated By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Employee updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }
     
    }


    public function delete_service_sections(Request $request){
        $id=$request->id;
        $details=ServiceSectionModel::where('service_sec_id',$id)->first();
        $update=ServiceSectionModel::where('service_sec_id',$id)->update(['section_status'=>1]);
        if($update==1){
      ############################User Activity log#########################
      $user_activity_log['activity_ip']=$request->ip(); 
      $user_activity_log['activity_user_name']=Auth::user()->name;
      $user_activity_log['activity_user_id']=Auth::user()->id; 
      $user_activity_log['activity_action']="Deleted";
      $user_activity_log['activity_desc']='Employee '.$details->service_section_title.' Has Been Deleted By '.Auth::user()->name;
      user_activity_log($user_activity_log);
      ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Employee removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function service_sections_datatable(Request $request){
         $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_service_section.service_sec_id';
        $sort = 'DESC';
      if (isset($order[0]['column']) && isset($order[0]['dir'])) {
          $colNo = $order[0]['column'];
          $sort = $order[0]['dir'];
          if (isset($columns[$colNo]['name'])) {
              $colName = $columns[$colNo]['name'];
          }
      }


        $query_data = ServiceSectionModel::where('section_status',0)
        ->leftjoin('users','tbl_service_section.created_by','users.id')
        ->leftjoin('tbl_main_services','tbl_service_section.service_id','tbl_main_services.serv_id')
        ->select('tbl_service_section.*','users.name','tbl_main_services.service');
      if ($colName != '' && $sort != '') {
          $query_data->orderBy($colName, $sort);
      }
      else{
         $query_data->orderBy('service_sec_id', 'DESC');
      }
      $data = ['iTotalDisplayRecords' => $query_data->count(), 'iTotalRecords' => $query_data->count(), 'TotalDisplayRecords' => $limit];
      $data['data'] = $query_data->skip($offset)->take($limit)->get()->toArray();
      return response()->json($data);
    }
    
} 
