<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Hash;
use Session;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Models\notificationModel;
use App\Models\SlotModel;
use App\Models\ServiceSectionModel;
use App\Models\JobRequests;
use DB;
use Spatie\Permission\Models\Role;

class authController extends Controller
{
    public function __construct()
    {
        ini_set('memory_limit', '44M');
    }

    public function index()
    {
        return view('admin.login');
    }

    public function customLogin(Request $request)
    {

        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            return redirect()->intended(route('dashboard'))
                ->withSuccess('Signed in');
        }
        return redirect("/")->witherror('Login details are not valid');
    }

    public function registration()
    {
        return view('auth.registration');
    }

    public function customRegistration(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:6',
        ]);

        $data = $request->all();
        $check = $this->create($data);

        return redirect("dashboard")->withSuccess('You have signed-in');
    }

    public function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password'])
        ]);
    }

    public function dashboard()
    {

        //Checking Role Has Super Wisor
        $roles_array = Auth::user()->getRoleNames()->toArray();
        $where_condition = 0;
        if (in_array("Super Admin", $roles_array) || in_array("Admin", $roles_array)) {
            $where_condition = 0;
        } else if (in_array("Superwisor", $roles_array)) {
            $where_condition = 1;
        }
        //End Of Checking Supwerwisor Role



        //User counts
        $data['user_count'] = User::where('u_status', 0)->count();
        
        // Check The User Roles
        $users = User::role('Super Admin')->where('id', Auth::user()->id)->get();

        //Notification Count
        $data['slot_count'] = SlotModel::select('*')->where('slot_status',0)->count();
            
            
        $data['employee_count'] = ServiceSectionModel::select('*')
            ->where('section_status', 0)->count();
            
        
        $data['jobs_count'] = JobRequests::select('*')->count();
            
        
        $data['notification_count'] = notificationModel::select('*')
            ->where('notification_status', 0)->count();

        //Payment Success Order Count
        //$data['order_success_count'] = orderModel::select('*')->where('o_status', 0)->where('o_payment_status', "Paid")->count();

        //Payment Failed Order Count
        //$data['order_failed_count'] = orderModel::select('*')->where('o_status', 0)->where('o_payment_status', "Not Paid")->count();



        //Order Graph Presentaion Month wise Section

        /*$data['graph_max_size'] = 10;
        $data['graph_setp_size'] = 1;

        $monthwise_order_data = orderModel::select(
            DB::raw('count(o_id) as total_order_count'), DB::raw("MONTHNAME(o_date) as month_name"), DB::raw('YEAR(o_date) year')
        )
            ->where('o_status', 0)
            ->whereYear('o_date', date('Y'))
            ->groupBy('month_name', 'year')
            ->get()->toArray();

        $months = array();
        for ($i = 6; $i >= 0; $i--) {
            $time = strtotime(date('Y-m-01') . " -$i months");
            $months[] = date('F', $time);
        }*/

        //End Of Recent Month Name


        /*$i = 0;
        $graph_value_array1 = [];
        foreach ($months as $month) {
            $graph_value_array1[$i] = 0;
            foreach ($monthwise_order_data as $monthwise_order_data1) {
                if ($monthwise_order_data1['month_name'] == $month) {

                    if ($monthwise_order_data1['total_order_count'] > $data['graph_max_size']) {
                        $data['graph_max_size'] = $monthwise_order_data1['total_order_count'];
                        $data['graph_setp_size'] = $data['graph_max_size'] / 10;
                    }

                    $graph_value_array1[$i] = $monthwise_order_data1['total_order_count'];
                }
            }
            $i++;
        }
        $data['chart_label'] = $months;
        $data['graph_value_array1'] = $graph_value_array1;*/





        //End OF Order Graphical Presentation Month Wise




        return view('admin.index')->with(['data' => $data]); //Admin Dashboard
    }

    public function signOut()
    {
        Session::flush();
        Auth::logout();

        return Redirect('/' . env('ADMIN_ROUTE'));
    }
}