<?php

namespace App\Http\Controllers;
use Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\permissioncategoryModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
class rolesController extends Controller
{
    
        public function __construct()
    {
        ini_set('memory_limit', '88M');
    }
    
    
   public function index(){
   $permission_categories=permissioncategoryModel::where('p_category_status',0)->where('p_category_id','!=',1)->get();
   for($i=0;$i<count($permission_categories);$i++){
      $permission_categories[$i]->permissions=$permissions=Permission::where('category_id',$permission_categories[$i]->p_category_id)->get();
   }
   return view('admin.master_settings.rules')->with('permission_categories',$permission_categories);
   }
   public function roles_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'roles.id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }


        $role_data=$roles = Role::select('roles.*','users.name as usersname')
        ->leftjoin('users','users.id','roles.created_by')
        ->Where(function($query) use ($search) {
            $query->where('roles.name', 'like', $search . '%');
            $query->Orwhere('users.name', 'like', $search . '%');
        });
       
       if ($colName != '' && $sort != '') {
           $role_data->orderBy($colName, $sort);
       }
       else{
         $role_data->orderBy('roles.id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $role_data->count(), 'iTotalRecords' => $role_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $role_data->skip($offset)->take($limit)->get()->toArray();
       return response()->json($data);
   }
   public function add_role(Request $request){ 
    $validator = Validator::make($request->all(), [
            'role_name'=>'required',
            'permission'=>'required'
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        $check_role_exist=Role::where('name',$request->role_name)->first();
        if($check_role_exist){
        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Role Already Exist']);
        }
            $role = Role::create(['name' => $request->input('role_name'),'status'=>'0','created_by'=>Auth::user()->id]);
            $role->syncPermissions($request->input('permission'));
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Role Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Role Added Successfully']);
   }
   public function edit_role(Request $request){
      $id=$request->id;
      $role_data=Role::select('*')->where('id',$id)->first();
      $rolePermissions = Permission::select('id')->join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
            ->where("role_has_permissions.role_id",$id)
            ->get();
      return response()->json(['status' => '0', 'msg' => 'succes','data'=>$role_data,'permissions'=>$rolePermissions]);
   }
   public function  update_role(Request $request){
   $validator = Validator::make($request->all(), [
            'role_name'=>'required',
            'permission'=>'required'
        ]);
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        $id=$request->role_id;
        $role = Role::find($id);
        $role->name = $request->input('role_name');
        $role->save();
        $role->syncPermissions($request->input('permission'));
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Role '.$role->name.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
        return response()->json(['status' => '0', 'heading' => 'succes','msg'=>'Role Updated Successfully']);
   }
   public function role_view(Request $request){
      $id=$request->id;
      $data['role_data']=Role::select('*')->where('id',$id)->first();
      $data['rolePermissions'] = Permission::select('id','name','category_id')->join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
            ->where("role_has_permissions.role_id",$id)
            ->get();
      $data['permission_category']=permissioncategoryModel::where('p_category_status',0)->get();
      return view('admin.master_settings.roles-modal')->with('data',$data);
   }
   public function delete_role(Request $request){
        $id=$request->id;
        $role=Role::find($id);
        $delete=$role->delete();
        if($delete==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='The Role '.$role->name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'role removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
   }
}
