<?php

namespace App\Http\Controllers\website;

use Illuminate\Support\Facades\Http;
use App\Http\Controllers\Controller;
use App\Models\MainServiceModel;
use App\Models\SlotModel;
use App\Models\ServiceSectionModel;
use App\Models\Chat_bot_user;
use App\Models\JobRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Exception;
use Auth;
use Barryvdh\DomPDF\PDF;
use Dompdf\Options;
use Illuminate\Support\Facades\DB;
use Mpdf\Mpdf;
use setasign\Fpdi\PdfParser\StreamReader;
use setasign\Fpdi\Tcpdf\Fpdi;
use setasign\Fpdi\PdfParser\PdfReader;

class HomeController extends Controller
{
    public function index()
    {
        $data["slots"]=SlotModel::select('*')->where('slot_status',0)->orderBy('slot_id','DESC')->get();
        return view('website.index')->with($data);
    }


    public function verify_number(Request $request)
    {
        $number = $request->id;

        $data=Chat_bot_user::select('*')->where('number','like','%'.$number.'%')->orderBy('id','DESC')->first();
        return response()->json($data);

    }

    

    public function save_jobs(Request $request){

        $this->validate(request(),[
          'ph_no' => 'required',
          'name' => 'required',
          'location' => 'required',
          'property_type' => 'required',
            'floor_code' => 'required',
            'room_no' => 'required',
            'maintanance_type' => 'required',
          'message' => 'required',
        ]);



        $news=new JobRequests();
        $news->ph_no=$request->ph_no;
        $news->name=$request->name;
        $news->location=$request->location;
        $news->property_type=$request->property_type;
        $news->floor_code=$request->floor_code;
        $news->room_code=$request->room_no;
        $news->maintenance_type=$request->maintanance_type;
        $news->issue_details=$request->message;
        
        
        /*$apiEndpoint = 'https://chatbot.gingertechnologies.app/chatbot_send_msg';


        $postData = [
          'name' => $request->name,
          'phone_no' => '91'.$request->ph_no,
          'text' => 'We have received you`re Complaint for '.$request->service.' on '.date('d-m-Y',strtotime($request->serv_date)).' - '.$request->slot_val.'. We will get back to you as soon as possible!'
          // Add more key-value pairs as needed
        ];


        $response = Http::post($apiEndpoint, $postData);*/

          /*if ($response->successful()) {*/
            
            $news->save();
            return back()->with('success','Your Message Has Been Sent Succesfully');

          /*} else {

            return back()->with('error','Message Send Failed');

          }*/



    }




}