<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class Localization
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $currentURL = url()->current();
        if (strpos($currentURL, 'ar-qa') !== false) {
            Session::put('language', 1); //Arabic session 2 Ayi Set Cheyyyunnu
            Session::put('locale', 'ar'); 
            app()->setLocale('ar');
        } else {
            Session::put('language', 0); //English Ayi Set Cheyyunnu
            Session::put('locale', 'en');
            app()->setLocale('en');
        }
        return $next($request);
    }
}
