<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AlertMail extends Mailable
{
    use Queueable, SerializesModels;

    public $details;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        //
        $this->details = $details;
    }

    /**
     * Build the message. 
     *
     * @return $this
     */
    public function build()
    {

        if ($this->details['email_type'] == 'order_alert') {
            $subject = env('APP_NAME')." - " . $this->details['Heading'];
            return $this->subject($subject)->view('admin.mails.order_confirmed');
        } else if ($this->details['email_type'] == 'stock_alert') {
            $subject = env('APP_NAME') . ' Product Out Of Stock Alert';
            return $this->subject($subject)->view('admin.mails.stock_alert');
        // } else if ($this->details['email_type'] == 'registration_link') {
        //     $subject = env('APP_NAME') . ' Confirmation Mail';
        //     return $this->subject($subject)->view('admin.mails.register_gmail');
        // } else {
        //     dd($this->details['email_type']);
        //     return $this->subject($subject)->view('admin.mails.register_email');
        }
    }
}
