<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblBranchTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_branch', function (Blueprint $table) {
            $table->integer('branch_id', true);
            $table->integer('branch_status')->default(0);
            $table->string('branch_name', 250)->nullable();
            $table->string('branch_short_code', 100)->nullable();
            $table->string('branch_mob', 100)->nullable();
            $table->string('branch_land', 100)->nullable();
            $table->string('branch_email', 100)->nullable();
            $table->string('branch_website', 100)->nullable();
            $table->string('branch_address', 250)->nullable();
            $table->string('branch_street', 100);
            $table->string('branch_place', 100);
            $table->string('branch_po_box', 100);
            $table->string('branch_city', 100)->nullable();
            $table->string('branch_country', 100)->nullable();
            $table->text('branch_logo')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_branch');
    }
}
