<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_category', function (Blueprint $table) {
            $table->integer('category_id', true);
            $table->string('category_ip', 100);
            $table->integer('category_status')->default(0)->comment('0->active,1->removed');
            $table->text('category_name');
            $table->text('category_image');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_category');
    }
}
