<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_order_items', function (Blueprint $table) {
            $table->integer('o_item_id', true);
            $table->integer('o_item_status');
            $table->integer('o_id');
            $table->date('o_item_date')->nullable();
            $table->integer('o_item_product_id');
            $table->string('o_item_name', 100)->nullable();
            $table->integer('o_item_cutting_type')->default(0);
            $table->float('o_item_rate', 10)->nullable()->default(0);
            $table->float('o_item_cost', 10)->nullable()->default(0);
            $table->float('o_item_sub_total', 10)->nullable()->default(0);
            $table->float('o_item_discount', 10)->nullable()->default(0);
            $table->float('o_item_profit', 10)->nullable()->default(0);
            $table->float('o_item_grand_total', 10)->default(0);
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->dateTime('created_at', 6);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_order_items');
    }
}
