<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_orders', function (Blueprint $table) {
            $table->integer('o_id', true);
            $table->integer('o_status')->default(0);
            $table->text('o_ip')->nullable();
            $table->string('o_date', 20)->nullable();
            $table->string('o_time', 20)->nullable();
            $table->string('order_unique_id', 100)->nullable();
            $table->integer('order_token_id')->nullable();
            $table->string('order_token_number', 100)->nullable();
            $table->integer('o_cust_id')->nullable();
            $table->string('c_cust_name', 100)->nullable();
            $table->string('o_cust_mob', 100)->nullable();
            $table->string('o_cust_email', 100)->nullable();
            $table->string('o_payment_type', 100)->nullable();
            $table->string('o_payment_status', 10)->nullable();
            $table->integer('o_invoiced')->default(0)->comment('1->invoiced');
            $table->integer('o_tracking_status')->nullable()->comment('1->packed,2->shipped,3->out for delivery,4->delivered,5->returned,6->canceled,7->unknown');
            $table->float('o_sub_total', 10)->default(0);
            $table->float('o_discount', 10)->nullable()->default(0);
            $table->float('o_shipping_charge', 10)->default(0);
            $table->float('o_cost', 10)->default(0);
            $table->float('o_profit', 10)->default(0);
            $table->float('o_grand_total', 10)->default(0);
            $table->integer('o_cancel_status')->nullable()->default(0);
            $table->string('o_cancel_reason', 250)->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
            $table->dateTime('created_at', 6);
            $table->integer('created_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_orders');
    }
}
