<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_products', function (Blueprint $table) {
            $table->integer('product_id', true);
            $table->string('product_ip', 100)->nullable();
            $table->string('product_status', 100)->default('0');
            $table->string('product_sku', 100)->nullable();
            $table->string('product_name', 250)->nullable();
            $table->integer('product_category')->nullable();
            $table->integer('product_subcategory')->nullable();
            $table->integer('product_origin')->nullable();
            $table->integer('product_breed')->nullable();
            $table->integer('product_arrival_type')->nullable();
            $table->integer('product_weight_slab')->nullable();
            $table->float('product_landing_weight', 10)->nullable();
            $table->float('product_landing_price', 10)->nullable();
            $table->float('current_weight', 10)->nullable();
            $table->string('dressed_weight', 10)->nullable();
            $table->float('selling_price', 10)->nullable();
            $table->integer('product_instock')->default(0)->comment('0->instock,1->out of stock');
            $table->timestamp('created_at')->useCurrent();
            $table->integer('created_by');
            $table->timestamp('updated_at')->useCurrent();
            $table->integer('updated_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_products');
    }
}
