function createOrUpdate(
    url,
    formId,
    modalId,
    dataTable,
    redirectUrl,
    validation
) {
    if (validation != false) {
        $("#" + formId)
            .parsley()
            .validate();
        if (
            !$("#" + formId)
                .parsley()
                .isValid()
        ) {
            return false;
        }
    }
    var formData = new FormData($("#" + formId)[0]);
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        async: true,
        cache: false,
        contentType: false,
        enctype: "multipart/form-data",
        processData: false,
        success: function (result) {
            if (modalId) {
                $("#" + modalId).modal("hide");
            }
            toast(result, dataTable, formId, redirectUrl);
        },
        error: function () {},
    });

    return false;
}

function toast(data, datatable = "", formId = "", redirectUrl = "") {
    if (data.status == 0) {
        //Success Anel
        $.toast({
            heading: data.heading,
            text: data.msg,
            position: "top-right",
            loaderBg: "#6c5ffc",
            bgColor: "#6c5ffc",
            icon: "success",
            hideAfter: 1500,
            stack: 6,
        });
        if (formId) {
            custome_styles(formId);
            $("#" + formId)
                .parsley()
                .reset();
            $("#" + formId)[0].reset();
            $("#create_btn").show();
            $("#update_btn").hide();
        }
        //Multi select uncheckall
        var array = ["permission", "roles"];
        $.each(array, function (index, value) {
            var iNum = parseInt(value);
            $select = $("#" + value);
            $select.multipleSelect("uncheckAll");
        });
        //End Of Uncheck All
    } else if (data.status == 1) {
        $.toast({
            heading: data.heading,
            text: data.msg,
            position: "top-right",
            loaderBg: "red",
            icon: "error",
            hideAfter: 1500,
            stack: 6,
        });
    }
    if (datatable == "") {
        if (redirectUrl && data.status == 0) {
            window.onload = setTimeout(function () {
                window.location.replace(redirectUrl);
            }, 2000);
        } else if (data.status == 1) {
        } else {
            window.onload = setTimeout(function () {
                location.reload();
            }, 1500);
        }
    } else {
        $("#" + datatable)
            .DataTable()
            .ajax.reload(null, false);
        $(".remove_all_serv").remove();
    }
}

function custome_styles(form_id) {
    //Product Add  Section
    var rowCount = 1;
    if (form_id == "createproductForm") {
        $("#add_new_products").html(
            '<tr id="row_id_add_new_product' +
                rowCount +
                '"><td style="text-align:center">' +
                rowCount +
                '</td>	<td>  <select data-parsley-required-message="Product size Required" class="form-control"   name="sizes[]" id="size" required>' +
                options +
                '</select> </td><td ><input type="text" name="stock[]" class="form-control" data-parsley-required-message="Stock Required" required></td><td style="text-align:center;font-size: 20px;padding: 10px;" ><i onclick=remove_row_add_new_product(' +
                rowCount +
                ') class="fa fa-times-circle remove_row" aria-hidden="true"></i></td></tr>'
        );
        $("#section_product_detailing").html(
            '<tr id="row_id_detailing' +
                rowCount +
                '"><td style="text-align:center">' +
                rowCount +
                '</td>	<td> <textarea name="prodct_detailing[]" placeholder="Enter Detailing" class="form-control" id="" cols="40" rows="2"></textarea></td><td style="text-align:center;font-size: 20px;padding: 10px;"><i onclick=remove_row_detailing(' +
                rowCount +
                ') class="fa fa-times-circle remove_row" aria-hidden="true"></i></td></tr>'
        );
        $("#section_product_size_fit").html(
            '<tr id="row_id_row_size' +
                rowCount +
                '"><td style="text-align:center">' +
                rowCount +
                '</td>	<td><textarea name="product_size_fit_care[]" class="form-control" placeholder="Enter Size, Fit & Care"  id="" cols="40" rows="2"></textarea></td><td style="text-align:center;font-size: 20px;padding: 10px;"><i onclick=remove_row_size_fit(' +
                rowCount +
                ') class="fa fa-times-circle remove_row" aria-hidden="true"></i></td></tr>'
        );
    }
    //End Of Product Add Section
    else if (form_id == "createoutfitForm") {
        //Outfit Add Section
        $select.multipleSelect();
        $select.multipleSelect("setSelects", "");
    } //End Of Outfit add Section
    else if (form_id == "offerForm") {
        //Offer Section
        $("#offer_products option").removeAttr("selected", "selected");
        demo1.bootstrapDualListbox("refresh");

        window.onload = setTimeout(function () {
            $("#offer_products option").removeAttr("selected", "selected");
            demo1.bootstrapDualListbox("refresh");
        }, 50);
    }
}

//Notification Seen Status Chane
var token = $("meta[name='csrf-token']").attr("content");
$("#notification_div").click(function () {
    $.ajax({
        type: "POST",
        data: { _token: token },
        url: admin_route + "/update_notification_status",
        success: function (result) {},
    });
});

const audio = new Audio(app_url + "/assets/sounds/stock_reminder.mp3");

// ##############################Notification Sound#############

setInterval(function () {
    $.ajax({
        type: "POST",
        data: { _token: token },
        url: admin_route + "/new_notification",
        success: function (result) {
            const audio = new Audio(result.sound);
            if (result.count > 0) {
                audio.play();
            }
        },
    });
}, 6000);

// ####################################################
