@extends('layouts.app')
        @section('styles')
        <link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
        @endsection

            @section('content')

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Manage Admin</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Master Setting</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Add/Edit Admin</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            @canany(['admins-create','admins-edit'])
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Admin</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                                                    <input id="user_id" name="user_id" type="hidden" value="">
                                                    
                                                    @csrf
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Name *</label>
                                                        <input data-parsley-required-message="Name Required" type="text" class="form-control" name="name" id="name"
                                                            value="" required>   
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Mobile *</label>
                                                        <input data-parsley-required-message="Mobile Required" type="text" class="form-control" name="mobile" id="mobile"
                                                            value="" required>   
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Email </label>
                                                        <input  type="text" class="form-control" name="email" id="email" value="" >   
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Profile Photo (150x150px)</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="image" id="image" value="">
                                                    </div>

                                          


                                                     <div  class="form-group col-xl-4 mb-3" >
                                                    <label for="validationTooltip01">Select Roles *</label>
                                               
                                                    <select data-parsley-required-message="Roles required"  required multiple="multiple" class="filter-multi" name="roles[]" id="roles">
                                                            @foreach ($roles as $role)
                                                          
                                                                <option value="{{$role}}">{{$role}}</option>
                                                            @endforeach
                                                        </select>
                                                </div>
                                                
                                                  <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">User Name * </label>
                                                        <input  type="text" data-parsley-required-message="Admin ID Required"  class="form-control" name="username" id="username" value="" required>   
                                                    </div>
                                                       <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Password * </label>
                                                        <input  type="text" data-parsley-required-message="Password Required"  class="form-control" name="password" id="password" value="12345678" required>   
                                                    </div>
                                                       <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Confirm Password * </label>
                                                        <input  type="text" data-parsley-required-message="Confirm Password Required"  class="form-control" name="confirm_password" id="confirm_password" value="12345678" required>   
                                                    </div>
                                                   
                                                   
                                                </div>
                                                @can('admins-create')
                                                <a id="create_btn" href="#" onclick="createOrUpdate('{{url(env('ADMIN_ROUTE').'/add_user')}}', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                @endcan
                                                @can('admins-edit')
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('{{url(env('ADMIN_ROUTE').'/update_user')}}', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                                @endcan 
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endcanany
                            <!-- /ROW-1 CLOSED -->  
                               <!-- Row -->
                        @can('admins-list')
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Admins</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Admin ID</th>
                                                        <th class="wd-15p border-bottom-0">Name</th>
                                                        <th class="wd-15p border-bottom-0">Mobile </th>
                                                        <th class="wd-15p border-bottom-0">Email  </th>
                                                        <th class="wd-15p border-bottom-0"> Actions </th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        @endcan
                        
                        <!-- End Row -->
                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete.. ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
            {{-- ####################delete Model############################# --}}
            {{-- #########################View Modal################################### --}}
            <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="view_modal_title"></h5>
                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body"  id="view_modal_body">
                        
                    </div>
                    <div class="modal-footer">
                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
            {{-- #########################End Of View Modal############################ --}}

                        
                        

            @endsection

        @section('scripts')  
{{-- ################################Jquery Datatable########################### --}}
   <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
   <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v3')}}">
   <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
 {{-- ########################################################################## --}}
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    var admin_route="/{{env('ADMIN_ROUTE')}}";

    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,1,5]},
           {"className": "text-left", "targets": [2,3,4]}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  admin_route+"/user_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "id", "name": "id"},
                  {"data": "user_unique_id", "name": "user_unique_id"},
                  {"data": "name", "name": "name"},
                  {"data": "mobile", "name": "mobile"},
                  {"data": "email", "name": "email"},
                  {"data": "id", "name": "id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
            //View action
            var action=action+'&nbsp;<button title="View" onclick=view('+aData.id+') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
            //Edit Action
            @can('admins-edit')
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            @endcan
            //Delete Action
            @can('admins-delete')
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            @endcan
            $('td:eq(0)', nRow).html(index);
            $('td:eq(5)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: admin_route+'/edit_user',
                    success: function (result) {
                        $('#user_id').val(result.user.id);
                        $('#name').val(result.user.name);
                        $('#mobile').val(result.user.mobile);
                        $('#email').val(result.user.email);
                        $('#username').val(result.user.username);
                        $('#seller').val(result.user.seller_id);
                         var roles=result.userRole;
                        $select = $("#roles");
                        $(function () {
                            var roles_array = [];
                            $.each(roles, function (index, roles) {
                            roles_array.push(roles);
                            });
                            $select.multipleSelect();
                            $select.multipleSelect("setSelects", roles_array);
                        });
                        $('#password').attr('required', false).val(''); 
                        $('#confirm_password').attr('required', false).val(''); 
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#user_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#user_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: admin_route+'/delete_user',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################
      // #################### View Section #########################
      function view(id){
           $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: admin_route+'/user_view',
                        success: function (result) {
                            $('#view_modal_title').text('Admin Details');
                            $('#view_modal_body').html(result);
                            $('#scrollingmodal').modal('show');
                        }
                    })
      }
    //    #################### End Of View Section ##################

        </script>
        @endsection
