@extends('layouts.app')
        @section('styles')
        <link href="{{asset('assets/css/custom_style.css')}}" rel="stylesheet" />
        @endsection

            @section('content')

                            <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Manage Roles</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Master Setting</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Permissions</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                        @canany(['role-create','role-edit'])
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Roles</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="{{ csrf_token() }}">
                                                    <input id="role_id" name="role_id" type="hidden" value="">
                                                    
                                                    @csrf
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Role Name *</label>
                                                        <input data-parsley-required-message="Role Name Required" type="text" class="form-control" name="role_name" id="role_name"
                                                            value="" required>
                                                            
                                                    </div>
                                             
                                                    <div class="col-xl-8 mb-3">
                                                     <label for="validationTooltip01">Choose Permissions *</label>
                                                    <select data-parsley-required-message="permission Required" name="permission[]" id="permission" multiple="multiple" class="group-filter" required>                                                          
                                                        </select>
                                                    </div>
                                                   
                                                   
                                                </div>
                                                @can('role-create')
                                                <a id="create_btn" href="#" onclick="createOrUpdate('{{url('/admin/add_role')}}', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Save</a>
                                                @endcan
                                                @can('role-edit')
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('{{url('/admin/update_role')}}', 'createForm', '', 'table_datatable','')" class="btn btn-primary"><i class="fa fa-save"></i> Update</a>
                                                @endcan
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endcanany
                            <!-- /ROW-1 CLOSED -->  
                               <!-- Row -->
                        @can('role-list')
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Roles</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Name</th>
                                                        <th class="wd-15p border-bottom-0">Created at </th>
                                                        <th class="wd-15p border-bottom-0">Added By </th>
                                                        <th class="wd-15p border-bottom-0"> Action </th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        @endcan
                        
                        <!-- End Row -->
                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete.. ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn btn-primary">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
            {{-- ####################delete Model############################# --}}
            {{-- #########################View Modal################################### --}}
            <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="view_modal_title"></h5>
                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body"  id="view_modal_body">
                        
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
            {{-- #########################End Of View Modal############################ --}}

                        
                        

            @endsection

        @section('scripts')  
{{-- ################################Jquery Datatable########################### --}}
   <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
   <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v3')}}">
   <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
 {{-- ########################################################################## --}}
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,1,2,3,4]},
           {"className": "text-left", "targets": []}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  "/admin/roles_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "id", "name": "id"},
                  {"data": "name", "name": "name"},
                  {"data": "created_at", "name": "created_at"},
                  {"data": "usersname", "name": "usersname"},
                  {"data": "id", "name": "id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          var created_at=aData.created_at.substring(0, 10)
            //View action
            var action=action+'&nbsp;<button title="View" onclick=view('+aData.id+') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-eye"> </span></button>';
            //Edit Action
            @can('role-edit')
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.id+') id="bEdit" type="button" class="btn btn-sm btn-primary"><span class="fe fe-edit"> </span></button>';
            @endcan
            //Delete Action
            @can('role-delete')
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.id+')" id="bDel" type="button" class="btn  btn-sm btn-danger"><span class="fe fe-trash-2"> </span></button>';
            @endcan
            $('td:eq(0)', nRow).html(index);
            $('td:eq(2)', nRow).html(created_at);
            $('td:eq(4)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: '/admin/edit_role',
                    success: function (result) {
                        var permissions=result.permissions;
                        $select = $("#permission");
                        $(function () {
                            var permission_array = [];
                            $.each(permissions, function (index, permission) {
                                var iNum = parseInt(permission.id);
                                permission_array.push(iNum);
                            });
                            $select.multipleSelect();
                            $select.multipleSelect("setSelects", permission_array);
                        });
                        $('#role_id').val(result.data.id);
                        $('#role_name').val(result.data.name);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#role_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#role_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/admin/delete_role',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################
      // #################### View Section #########################
      function view(id){
           $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/admin/role_view',
                        success: function (result) {
                            $('#view_modal_body').html(result);
                            $('#scrollingmodal').modal('show');
                        }
                    })
      }
    //    #################### End Of View Section ##################

        </script>
        @endsection
