@php
    $users=$data['fetch_user'];
@endphp
@extends('layouts.app')

        @section('styles')

        @endsection

            @section('content')
                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Activity List</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">User Activity</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                               <!-- Row -->
                       
                            <input type="hidden" name="" id="order_id">
                             <div class="row">
                            <div class="col-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title mb-0">View User Activity </h3>
                                    </div>
                                    <div class="card-body pt-4">
                                        <div class="grid-margin">
                                            <div class="">
                                                <div class="panel panel-primary">
                                                    <div class="tab-menu-heading border-0 p-0">
                                                        <div class="tabs-menu1">
         
                                                            <ul class="nav panel-tabs product-sale">
                                                         @hasanyrole('Super Admin|Admin')
                                                            <li class="px-2" style="border: none;">
                                                            <select name="" class="form-control" id="user_filtering">
                                                                <option value="0">-- Choose User --</option>
                                                                @foreach ($users as $user)
                                                                @php
                                                                    $selected="";
                                                                @endphp
                                                                @if (session('user_filter'))
                                                                   @if (session('user_filter')==$user['id'])
                                                                    @php
                                                                        $selected="Selected";
                                                                    @endphp   
                                                                   @endif
                                                                @endif
                                                                  <option {{$selected}} value="{{$user['id']}}">{{$user['name']}}</option>  
                                                                @endforeach
                                                            </select>
                                                            </li>

                                                         <li style="border: none;">
                                                           <button id="reset_btn"  class="btn btn-danger"><i class="fa fa-repeat"></i></button>  
                                                         </li>
                                                            @endhasanyrole
                                                
                                                         </ul>
                                                        </div>
                                                    </div>
                                                    <div class="panel-body tabs-menu-body border-0 pt-0">
                                                        <div class="tab-content">
                                                            <div class="tab-pane active" id="tab5">
                                                                <div class="table-responsive">
                                                                    <table class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;"  id="table_datatable"
                                                                        class="table table-bordered text-nowrap mb-0">
                                                                        <thead class="border-top text-center">
                                                                            <tr>
                                                                                <th class="bg-transparent border-bottom-0"
                                                                                    style="width: 5%;">#</th>
                                                                                <th
                                                                                    class="bg-transparent border-bottom-0">
                                                                                    Date</th>
                                                                             
                                                                                <th
                                                                                    class="bg-transparent border-bottom-0">
                                                                                    Time</th>
                                                                                <th class="bg-transparent border-bottom-0">
                                                                                   Name</th>
                                                                                <th
                                                                                    class="bg-transparent border-bottom-0">
                                                                                    Action</th>
                                                                                           <th
                                                                                    class="bg-transparent border-bottom-0">
                                                                                    Activity</th>
                                                                            </tr>
                                                                        </thead>
                                                               
                                                                    </table>
                                                                </div>
                                                            </div>
                                                           
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End Row -->




                  

          

       
                      

            @endsection
              @section('scripts')  
{{-- ################################Jquery Datatable########################### --}}
   <script src="{{asset('assets/jquery-datatable/jquery.min.js')}}"></script>
   <link rel="stylesheet" type="text/css" href="{{asset('assets/jquery-datatable/jquery.dataTables.css?v3')}}">
   <script src="{{asset('assets/jquery-datatable/jquery.dataTables.js')}}"></script>
 {{-- ########################################################################## --}}
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var base_url='{{url('/')}}';
    var print_url  = '{{url('')}}/order_print';
    var datatable_name="table_datatable";
    var admin_route="/{{env('ADMIN_ROUTE')}}";
$('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,1,2,4]},
           {"className": "text-left", "targets": [3,5]},
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  admin_route+"/user_activity_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "activity_id", "name": "activity_id"},
                  {"data": "activity_id", "name": "activity_id"},
                  {"data": "activity_id", "name": "activity_id"},
                  {"data": "name", "name": "name"},
                  {"data": "activity_action", "name": "activity_action"}, 
                  {"data": "activity_desc", "name": "activity_desc"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));         
            $('td:eq(0)', nRow).html(index);
            var time_stamp=aData.created_at;
            var date=time_stamp.slice(0,10);
             var time=time_stamp.slice(11,16);
            var time= tConvert (time);
            $('td:eq(1)', nRow).html(date);
            $('td:eq(2)', nRow).html(time);
 }
 });



 function tConvert (time) {
  // Check correct time format and split into components
  time = time.toString ().match (/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

  if (time.length > 1) { // If time format correct
    time = time.slice (1);  // Remove full string match value
    time[5] = +time[0] < 12 ? 'AM' : 'PM'; // Set AM/PM
    time[0] = +time[0] % 12 || 12; // Adjust hours
  }
  return time.join (''); // return adjusted time or original string
}



$('#user_filtering').change(function(){
    var user_id=$('#user_filtering').val();
            $.ajax({
                        type: 'POST',
                        data: {"_token": token,"user_id": user_id},
                        url: admin_route+'/filter_user',
                        success: function (result) {
                        $("#table_datatable").DataTable().ajax.reload(null, false);
                        }
                    })
});



$('#reset_btn').click(function(){
           $.ajax({
                        type: 'POST',
                        data: {"_token": token},
                        url: admin_route+'/reset_session',
                        success: function (result) {
                        $("#table_datatable").DataTable().ajax.reload(null, false);
                        $('#user_filtering').val(0);
                        
                        }
                    })
});



        </script>
        @endsection


