<!doctype html>
<html lang="en" dir="ltr" style="--primary01:rgba(28, 28, 28, 0.1); --primary02:rgba(28, 28, 28, 0.2); --primary03:rgba(28, 28, 28, 0.3); --primary06:rgba(28, 28, 28, 0.6); --primary09:rgba(28, 28, 28, 0.9); --primary-bg-color:#1c1c1c; --primary-bg-hover:#1c1c1c95; --primary-bg-border:#1c1c1c; --primary-transparentcolor:#1c1c1c20;">

<head>

    <!-- META DATA -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="">
    <meta name="author" content="™">
    <meta name="keywords" content="">
    <meta property="og:image" content="{{asset('assets/images/logo1.svg?v1')}}">
    <meta name="csrf-token" content="{{csrf_token()}}">
    <!-- title -->
    <title>{{ env('APP_NAME') }}</title>

    @include('layouts.components.styles')

</head>
    <!-- Dark And Liight Mode -->
@if (session('light_mode_class_name'))
@php
    $class_name=session('light_mode_class_name');
@endphp
@else
@php
    $class_name="app sidebar-mini ltr";
@endphp
@endif
  <!-- End Of Dark And Liight Mode -->
<!-- Side Menu Folding Mode -->
@php
    $side_menu_class_name="";
@endphp
@if (session('side_menu_class_name'))
@php
    $side_menu_class_name=session('side_menu_class_name');
@endphp
@endif
<!-- End Of Side Menu Folding Mode -->
    <body class="{{$class_name}} {{$side_menu_class_name}}">

        <!-- global-loader -->
        <div id="global-loader">
            <img src="{{asset('assets/images/loader.gif')}}" class="loader-img" alt="Loader">
        </div>
        <!-- global-loader closed -->

        <!-- page -->
        <div class="page">
            <div class="page-main">

                @include('layouts.components.app-header')

                @include('layouts.components.app-sidebar')

                    <!--app-content open-->
                    <div class="main-content app-content mt-0">
                        <div class="side-app">

                            <!-- container -->
                            <div class="main-container container-fluid">

                                @yield('content')

                            </div>
                            <!-- container-closed -->
                        </div>
                    </div>
                    <!--app-content closed-->
                </div>
                <!-- page-main closed -->

            @include('layouts.components.sidebar-right')

            @include('layouts.components.modal')

            @yield('modal')

            @include('layouts.components.footer')

        </div>
        <!-- page -->

        @include('layouts.components.scripts')

    </body>

</html>
