        <?php $__env->startSection('styles'); ?>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                            <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Sub Categories</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Products</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Sub Categories</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['subcategory-create','subcategory-edit'])): ?>
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Sub Category</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="subcategory_id" name="subcategory_id" type="hidden" value="">
                                                    
                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">

                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Select Category *</label>
                                                        <select data-parsley-required-message="Choose Category" type="text" class="form-control" name="category_id" id="category_id" required>
                                                       <option value="">--Choose Category--</option>
                                                        <?php $__currentLoopData = $data['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                       <option value="<?php echo e($category->category_id); ?>"><?php echo e($category->category_name); ?></option>   
                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>  
                                                    </div>
                                                    
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Sub Category Name *</label>
                                                        <input data-parsley-required-message="Subcategory Name Required" type="text" class="form-control" name="subcategory_name" id="subcategory_name"
                                                            value="" required>
                                                            
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Sub Category Icon (<?php echo e(env('CATEGORYIMAGESIZE')); ?>px)</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="image" id="image"
                                                            value="" >
                                                    </div>
                                                </div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subcategory-create')): ?>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('<?php echo e(url('/add_subcategory')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subcategory-edit')): ?>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('<?php echo e(url('/update_subcategory')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                                <?php endif; ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subcategory-list')): ?>
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Sub Categories</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table  class="table table-bordered text-nowrap border-bottom" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Category</th>
                                                        <th class="wd-15p border-bottom-0">Sub Category</th>
                                                        <th class="wd-15p border-bottom-0">Icon</th>
                                                         <th class="wd-15p border-bottom-0">Added By</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>
                                             
                                               
                                            </table>
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        <?php endif; ?>
                        <!-- End Row -->

                         <!-- Modal -->
                    <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the Sub Category ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        

            <?php $__env->stopSection(); ?>
 <?php $__env->startSection('scripts'); ?>  

   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css?v3')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
 
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,3,4,5]},
           {"className": "text-left", "targets": [1,2,]}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  "/subcategory_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "subcategory_id", "name": "subcategory_id"},
                  {"data": "category_name", "name": "category_name"},
                  {"data": "subcategory_name", "name": "subcategory_name"},
                  {"data": "subcategory_id", "name": "subcategory_id"},
                  {"data": "name", "name": "name"},
                  {"data": "subcategory_id", "name": "subcategory_id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          if(aData.subcategory_image=="" || aData.subcategory_image==null){aData.subcategory_image="no_image.png";}
          var image='<a style="cursor: pointer;" href="/uploads/subcategory_images/'+aData.subcategory_image+'" target="_blank"><img style="width:30px; height:30px" src="/uploads/subcategory_images/'+aData.subcategory_image+'"></a>';
            //Edit Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subcategory-edit')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.subcategory_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            <?php endif; ?>
            //Delete Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subcategory-delete')): ?>
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.subcategory_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            <?php endif; ?>
            $('td:eq(0)', nRow).html(index);
            $('td:eq(3)', nRow).html(image);
            $('td:eq(5)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: '/edit_subcategory',
                    success: function (result) {
                        $('#category_id').val(result.subcategory_cid);
                        $('#subcategory_id').val(result.subcategory_id);
                        $('#subcategory_name').val(result.subcategory_name);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#subcategory_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#subcategory_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/delete_subcategory',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################


        </script>
        <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deltaqatar/public_html/admin/resources/views/admin/subcategory/index.blade.php ENDPATH**/ ?>