<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="<?php echo e(asset('website/images/favicon.png')); ?>" type="image/x-icon">
  <title>Pioneers Dental</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/main-style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/fontawesome/css/all.min.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;500;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/aos.css')); ?>">
  
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/swiper-bundle.min.css')); ?>">
  <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JE7T79D1ES"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-JE7T79D1ES');
    </script>
</head>
<body>
<?php echo $__env->yieldContent('content'); ?>

<?php if(Request::segment(1) == 'insurance' || Request::segment(1) == 'contact-us'): ?>
<?php else: ?>
  <section class="bookonline px-md-5 px-0">
    <div class="container-fluid">
      <div class="row d-flex align-items-center">
        <div data-aos="fade-up" class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
          <h2 class="text-sm-start text-center mb-sm-5 mb-3">Feel free to contact us<span>.</span></h2>
          <form class="w-100 float-start" role="form">
            <div class="row">
              <div class="col-12 mb-3">
                <div class="form-floating">
                  <input class="form-control px-5" id="name" name="name" type="text" placeholder="Your Name">
                  <label class="px-5" for="name">Your Name</label>
                </div>
              </div>
              <div class="col-12 mb-3">
                <div class="form-floating">
                  <input class="form-control px-5" id="phone" name="phone" type="text" placeholder="Phone Number">
                  <label class="px-5" for="phone">Phone Number</label>
                </div>
              </div>
              <div class="col-12 mb-3">
                <div class="form-floating">
                  <input class="form-control px-5" id="email" name="email" type="email" placeholder="Email">
                  <label class="px-5" for="email">Email</label>
                </div>
              </div>
              <div class="col-12 mb-3">
                <div class="form-floating">
                  <textarea class="form-control px-5" id="message" name="message" rows="4" placeholder="Message"></textarea>
                  <label class="px-5" for="message">Message</label>
                </div>
              </div>
              <!--<div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 mb-3">
                <div class="form-floating">
                  <input class="form-control px-5" id="date" name="date" type="date" placeholder="Select Date">
                  <label class="px-5" for="date">Select Date</label>
                </div>
              </div>
              <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 mb-3">
                <div class="form-floating">
                  <input class="form-control px-5" id="time" name="time" type="time" placeholder="Select Time">
                  <label class="px-5" for="time">Select Time</label>
                </div>
              </div>-->
              <div class="col-12 text-lg-start text-center">
                <button class="bookonline_btn mt-5 trs" type="submit">Send Message <i class="fa-solid fa-arrow-right ms-2"></i></button>
              </div>
            </div>
          </form>
        </div>
        <div data-aos="fade-up" class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12 position-relative mt-lg-0 mt-5">
          <iframe class="hm_map float-start" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3608.7571165246886!2d51.48030790000001!3d25.2451044!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e45d13cbba02a1d%3A0xf707a0a37f82c4f5!2sPioneers%20Dental%20Center!5e0!3m2!1sen!2sqa!4v1699952753280!5m2!1sen!2sqa" width="100%" height="800" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          <div class="hm_location text-center d-flex align-items-center p-2 justify-content-sm-between justify-content-center flex-sm-nowrap flex-wrap">
            <img class="img-fluid" src="<?php echo e(asset('website/images/hm_location.jpg')); ?>" alt="Our Location">
            <div class="px-3">
              <h4 class="my-2">Our Location</h4>
              <h5 class="mb-2">You can now find us easily on Google Maps.</h5>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>
<!--************************************* footer *************************************-->
  <section data-aos="fade-up" class="footer px-md-5 px-0">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12 mb-4">
          <img class="img-fluid" src="<?php echo e(asset('website/images/logo.png')); ?>" alt="logo">
        </div>
        <div class="col-xxl-7 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 mb-4">
          <h4 class="col-xl-8 col-12 text-sm-start">We are committed to providing excellent dental care while emphasising patient comfort and happiness. Our skilled team of dentists is dedicated to providing tailored care using cutting-edge technology and techniques.</h4>
        </div>
        <div class="col-xxl-5 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 mb-4">
          <div class="row">
            <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12 mb-lg-0 mb-4">
              <h5>Phone Number<a class="trs mt-3" href="tel:+97444630746">+974 44630746</a></h5>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
              <h5>Email<a class="trs mt-3" href="mailto:Pioneersdentalcenter@gmail.com">Pioneersdentalcenter@gmail.com</a></h5>
            </div>
          </div>
        </div>
      </div>
      <div class="row footer_topline py-4">
        <div class="col-xxl-4 col-xl-4 col-lg-5 col-md-12 col-sm-12 col-12 mb-lg-0 mb-4">
          <div class="float-start">
            <h5 class="mb-3">Clinic Hours</h5>
            <h6>
              <p class="mb-3"><b>Saturday - Wednesday:</b> 8 AM - 10 PM</p>
              <p class="mb-3"><b>Thursday:</b> 8 AM - 4 PM</p>
              <p class="mb-3"><b>Friday: </b> Closed</p>
            </h6>
          </div>
          <div class="vr h-100 float-end d-lg-block d-none"></div>
        </div>
        <div class="col-xxl-3 col-xl-3 col-lg-2 col-md-4 col-sm-4 col-12">
          <ul>
              <li><a class="trs active" href="/">Home</a></li>
            <li><a class="trs" href="/about">About Us</a></li>
            <li><a class="trs" href="/services">Our Services</a></li>
            <!-- <li><a class="trs" href="our-clinics.html">Our Clinics</a></li> -->
          </ul>
        </div>
        <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-4 col-sm-5 col-12">
          <ul>
            <li><a class="trs" href="/doctors">Doctors</a></li>
            <li><a class="trs" href="/gallery">Gallery</a></li>
            <li><a class="trs" href="/contact-us">Location</a></li>
            <!--<li><a class="trs" href="privacy-policy.html">Privacy Policy</a></li>
            <li><a class="trs" href="terms-and-condition.html">Terms &amp; Condition</a></li>-->
          </ul>
        </div>
        <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-4 col-sm-3 col-12">
          <ul>
            <li><a class="trs social-media-icon" href="https://www.instagram.com/pioneers_dental/?hl=en" target="_blank"><i class="fa-brands fa-instagram"></i></a></li>
            <li><a class="trs social-media-icon"  href="https://wa.me/97430071171?text=Hi Pioneer Dental" target="_blank"><i class="fa-brands fa-whatsapp"></i></a></li>
            <!--<li><a class="trs" href="javascript:void(0)">Youtube</a></li>
            <li><a class="trs" href="javascript:void(0)">Twitter</a></li>-->
          </ul>
        </div>
      </div>
    </div>
  </section>
  <section class="copyright footer_topline px-md-5 px-0 text-sm-start text-center">
    <div class="container-fluid">
      Copyright <i class="fa-regular fa-copyright"></i> 2023&nbsp;Pioneer Dentals. All&nbsp;Rights&nbsp;Reserved. Developed&nbsp;by <a class="trs" href="https://gingertechnologies.qa/" target="_blank">Ginger&nbsp;Technologies</a>
    </div>
  </section>
    <a href="#" id="scroll" style="display: none;">Go&nbsp;To&nbsp;Top<span></span></a>
<!--************************************* common js **********************************-->
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery.min.js')); ?>"></script>
  <script type="text/javascript" src="<?php echo e(asset('website/js/bootstrap.bundle.min.js')); ?>"></script>
    <script>$(document).ready(function(){$(window).scroll(function(){$(this).scrollTop()>100?$("#scroll").fadeIn():$("#scroll").fadeOut()}),$("#scroll").click(function(){return $("html, body").animate({scrollTop:0},600),!1})});</script>
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery.smartmenus.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery.smartmenus.bootstrap-4.min.js')); ?>"></script>
  <script type="text/javascript" src="<?php echo e(asset('website/js/aos.js')); ?>"></script>
  <script>AOS.init({easing: 'ease-out-back',duration: 1200,});</script>
<?php echo $__env->yieldPushContent("custom-js"); ?>
</body>
</html>

<?php /**PATH C:\wamp64\www\Laravel\Ginger\pioneer_dental\resources\views/website/layouts/app.blade.php ENDPATH**/ ?>