      <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<form id="audioForm" method="post">
    <?php echo csrf_field(); ?>
    <div>
        <button id="recordButton">Record</button>
        <button id="stopButton" disabled>Stop</button>
    </div>
    <div>
        <audio id="audioPreview" controls></audio>
    </div>
    <div>
        <button type="submit">Upload</button>
    </div>
</form>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
<script>

    var constraints = { audio: true };
    var chunks = [];
      var token = $("meta[name=csrf-token]").attr("content");  


    navigator.mediaDevices.getUserMedia(constraints)
    .then(function(mediaStream) {
        var mediaRecorder = new MediaRecorder(mediaStream);

        document.getElementById('recordButton').addEventListener('click', function() {
            mediaRecorder.start();
            document.getElementById('stopButton').disabled = false;
            document.getElementById('recordButton').disabled = true;
        });

        document.getElementById('stopButton').addEventListener('click', function() {
            mediaRecorder.stop();
            document.getElementById('stopButton').disabled = true;
            document.getElementById('recordButton').disabled = false;
        });

        mediaRecorder.ondataavailable = function(e) {
            chunks.push(e.data);
        }

        mediaRecorder.onstop = function(e) {
            var audioBlob = new Blob(chunks, { 'type' : 'audio/ogg; codecs=opus' });
            chunks = [];

            var audioURL = window.URL.createObjectURL(audioBlob);
            document.getElementById('audioPreview').src = audioURL;

            var formData = new FormData();
            formData.append('audio', audioBlob);
            formData.append('_token', token);

            var xhr = new XMLHttpRequest();
            xhr.open('POST', '/upload-audio', true);
            xhr.onload = function(e) {
                if (this.status == 200) {
                    console.log(this.response);
                }
            };
            xhr.send(formData);
        }
    })
    .catch(function(err) {
        console.log('Error:', err);
    });

    document.getElementById('audioForm').addEventListener('submit', function(e) {
        e.preventDefault();
    });
</script>
<?php /**PATH /Applications/MAMP/htdocs/rakhil/ginger/oneworld/resources/views/website/test_page.blade.php ENDPATH**/ ?>