        <?php $__env->startSection('styles'); ?>
        <link href="<?php echo e(asset('assets/css/custom_style.css')); ?>" rel="stylesheet" />
        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                            <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Manage Roles</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Master Setting</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Roles</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Roles</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="role_id" name="role_id" type="hidden" value="">
                                                    
                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Role Name *</label>
                                                        <input data-parsley-required-message="Role Name Required" type="text" class="form-control" name="role_name" id="role_name"
                                                            value="" required>
                                                            
                                                    </div>
                                             
                                                    <div class="col-xl-8 mb-3">
                                                     <label for="validationTooltip01">Choose Permissions *</label>
                                                    <select data-parsley-required-message="permission Required" name="permission[]" id="permission" multiple="multiple" class="group-filter" required>
                                                        <?php $__currentLoopData = $permission_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <optgroup label="<?php echo e($permission_category->p_category_name); ?>">
                                                                <?php $__currentLoopData = $permission_category->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                            $permission_custom_array=['list','create','edit','delete'];
                                                                    ?>
                                                                      <?php $__currentLoopData = $permission_custom_array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(strpos($permissions->name, $custom_permission) !== false): ?>
                                                            <option value="<?php echo e($permissions->id); ?>"><?php echo e($custom_permission); ?></option> 
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </optgroup>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                                           
                                                        </select>
                                                    </div>
                                                   
                                                   
                                                </div>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('<?php echo e(url(env('ADMIN_ROUTE').'/add_role')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('<?php echo e(url(env('ADMIN_ROUTE').'/update_role')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /ROW-1 CLOSED -->  
                               <!-- Row -->
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Roles</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table  class="table table-bordered text-nowrap border-bottom " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Name</th>
                                                        <th class="wd-15p border-bottom-0">Created at </th>
                                                        <th class="wd-15p border-bottom-0">Added By </th>
                                                        <th class="wd-15p border-bottom-0"> Action </th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        
                        <!-- End Row -->
                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete.. ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
            
            
            <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="view_modal_title"></h5>
                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body"  id="view_modal_body">
                        
                    </div>
                    <div class="modal-footer">
                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
            

                        
                        

            <?php $__env->stopSection(); ?>

        <?php $__env->startSection('scripts'); ?>  

   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.min.js')); ?>"></script>
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css?v3')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
 
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    var admin_route="/<?php echo e(env('ADMIN_ROUTE')); ?>";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,1,2,3,4]},
           {"className": "text-left", "targets": []}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  admin_route+"/roles_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "id", "name": "id"},
                  {"data": "name", "name": "name"},
                  {"data": "created_at", "name": "created_at"},
                  {"data": "usersname", "name": "usersname"},
                  {"data": "id", "name": "id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          var created_at=aData.created_at.substring(0, 10)
            //View action
            var action=action+'&nbsp;<button title="View" onclick=view('+aData.id+') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
            //Edit Action
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            //Delete Action
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            $('td:eq(0)', nRow).html(index);
            $('td:eq(2)', nRow).html(created_at);
            $('td:eq(4)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: admin_route+'/edit_role',
                    success: function (result) {
                        var permissions=result.permissions;
                        $select = $("#permission");
                        $(function () {
                            var permission_array = [];
                            $.each(permissions, function (index, permission) {
                                var iNum = parseInt(permission.id);
                                permission_array.push(iNum);
                            });
                            $select.multipleSelect();
                            $select.multipleSelect("setSelects", permission_array);
                        });
                        $('#role_id').val(result.data.id);
                        $('#role_name').val(result.data.name);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#role_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#role_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: admin_route+'/delete_role',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################
      // #################### View Section #########################
      function view(id){
           $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: admin_route+'/role_view',
                        success: function (result) {
                            $('#view_modal_body').html(result);
                            $('#scrollingmodal').modal('show');
                        }
                    })
      }
    //    #################### End Of View Section ##################

        </script>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/staging/public_html/building_maintenance@staging/resources/views/admin/master_settings/rules.blade.php ENDPATH**/ ?>