<?php $__env->startSection('content'); ?>
<!--************************************* contact *************************************-->
	<section class="contact">
		<div class="container order-lg-1 order-2">
			<div class="row">
				<div data-aos="fade-up" class="col-lg-6 col-12 contact_box">
					<h2>Get In Touch</h2>
					<h1 class="mb-xl-4 mb-3">Contact Us</h1>
					<h4 class="text-lg-start mb-4">Give us a call or drop by anytime, we endeavour to answer all enquiries within 24 hours on business days.</h4>
				</div>
			</div>
		</div>
		<img data-aos="fade-up" class="img-fluid d-block w-100 d-none d-sm-none d-md-none d-lg-block d-xl-block d-xxl-block" src="<?php echo e(asset('website/images/contact_banner.webp')); ?>" alt="contact">
		<img data-aos="fade-up" class="img-fluid d-block w-100 d-block d-sm-block d-md-block d-lg-none d-xl-none d-xxl-none mb-4 order-lg-2 order-1" src="<?php echo e(asset('website/images/contact_mob_banner.webp')); ?>" alt="contact">
	</section>
	<section class="contact_form">
		<div class="container">
			<form data-aos="fade-up" action="/send-mail" method="post" class="w-100 float-start p-sm-5 py-5 px-3" role="form">
			    <?php echo csrf_field(); ?>
				<h2 class="mb-5">Lets keep in touch</h2>
				<div class="row gx-lg-5 gx-1">
					<div class="col-12 mb-4">
						<label for="contact_name">Full Name</label>
						<input class="form-control rounded-0" id="contact_name" name="firstname" type="text" required placeholder="Full Name">
					</div>
					<div class="col-lg-6 col-12 mb-4">
						<label for="contact_email">Email</label>
						<input class="form-control rounded-0" id="contact_email" name="email" type="email" required placeholder="Email">
					</div>
					<div class="col-lg-6 col-12 mb-4">
						<label for="contact_phone">Phone Number</label>
						<input class="form-control rounded-0" id="contact_phone" name="phone" maxlength="10" maxlength="13" type="text" required placeholder="Phone Number">
					</div>
					<div class="col-12 mb-4">
						<label for="contact_message">Message</label>
						<div class="input-group">
							<textarea required class="form-control rounded-0" id="contact_message" name="address" rows="4" placeholder="Enter Your Message"></textarea>
							<span class="input-group-text border-0 align-items-end p-0 bg-white">
								<button type="submit" class="contact_form_btn border-0 rounded-circle"><i class="fa-solid fa-paper-plane"></i></button>
							</span>
						</div>
					</div>
				</div>
			</form>
			
                                    <?php if(Session::has('success')): ?>
                                    <script>
                                        swal("Message Send Successfully!", "We have received you're message. We will get back to you as soon as possible!", "success");
                                    </script>
                                    <?php endif; ?>
                                
		</div>
	</section>
	<section data-aos="fade-up" class="contact_address">
		<div class="container d-md-flex d-block justify-content-between text-center">
			<div class="d-flex align-content-start flex-wrap mb-md-0 mb-5">
				<h4 class="mb-2">Office Address</h4>
				<h5>Main Road, Irinjalakuda, <br>Thrissur, Kerala, India</h5>
			</div>
			<div class="vr float-start bg-white mx-3 opacity-50 d-md-block d-none"></div>
			<div class="d-flex align-content-start flex-wrap mb-md-0 mb-5">
				<h4 class="mb-2">Phone And Email</h4>
				<h5>
					Phone: <a class="trs" href="tel:04802670400">0480&nbsp;2670400</a>, <a class="trs" href="tel:04802828071">0480&nbsp;2828071</a>, <a class="trs" href="tel:04802831305">0480&nbsp;2831305</a><br>
					Toll Free: <a class="trs" href="tel:1800 31 333 53">1800 31 333 53</a><br>
					Email: <a href="mailto:info@iclfincorp.com" class="trs">info@iclfincorp.com</a>
				</h5>
			</div>
			<div class="vr float-start bg-white mx-3 opacity-50 d-md-block d-none"></div>
			<div class="d-flex align-content-start flex-wrap">
				<h4 class="mb-2">Business Hours</h4>
				<h5>Monday - Saturday : 9.00&nbsp;am&nbsp;to&nbsp;5.30&nbsp;pm <br>Sunday : Holiday</h5>
		</div>
	</section>
	<section class="contact_map">
		<div class="container">
			<iframe data-aos="fade-up" class="float-start" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3924.935031513454!2d76.20939307481383!3d10.347080066966729!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba7f7d4d7359c13%3A0x54a3c743528cc4f6!2sICL%20FINCORP%20LTD!5e0!3m2!1sen!2sin!4v1697880300342!5m2!1sen!2sin" allowfullscreen="" width="100%" height="500" frameborder="0"></iframe>
		</div>
	</section>
	<section class="hm_branches mb-5 pb-5">
		<div data-aos="fade-up" class="container">
			<div class="row g-md-3 g-2">
				<h2 class="mb-lg-4 mb-3">Our Branches</h2>
				<?php $__currentLoopData = $avail_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $avails): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<div data-aos="zoom-in" class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-6 col-6 xxsm-100">
					<div class="position-relative overflow-hidden">
						<a class="shine_ani" href="/branches/<?php echo e(str_replace(' ','-',$avails->avail_state)); ?>">
							<img class="img-fluid d-block w-100" src="<?php echo e(asset('uploads/sliders/'.$avails->avail_image)); ?>" alt="Branches">
							<div class="hm_branches_title trs">
								<h3 class="mb-2"><?php echo e($avails->avail_state); ?></h3>
								<h4><?php echo e(\App\Models\branchModel::where(['branch_city' => $avails->avail_state])->count()); ?> Branches</h4>
							</div>
						</a>
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<div class="text-center mt-5">
					<a class="send_btn trs" href="/branches/<?php echo e($avail_locations[0]->avail_state); ?>">View All Branches <i class="fa-sharp fa-solid fa-arrow-right-long ms-3"></i></a>
				</div>
			</div>
		</div>
	</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('custom-js'); ?>
<!--************************************* common js **********************************-->
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery-3.7.1.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('website/js/bootstrap.bundle.min.js')); ?>"></script>
   	<script>$(document).ready(function(){$(window).scroll(function(){$(this).scrollTop()>100?$("#scroll").fadeIn():$("#scroll").fadeOut()}),$("#scroll").click(function(){return $("html, body").animate({scrollTop:0},600),!1})});</script>
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery.smartmenus.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('website/js/jquery.smartmenus.bootstrap-4.min.js')); ?>"></script>
    <script>$(window).scroll(function(){if($(document).scrollTop()<400){$(".menu_bg").removeClass("s_menu_bg")}else{$(".menu_bg").addClass("s_menu_bg")}})</script>
	<script type="text/javascript" src="<?php echo e(asset('website/js/aos.2.3.1.js')); ?>"></script>
	<script>AOS.init({easing: 'ease-out-back',duration: 1200,});</script>
	<script>
		var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
		var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
		  return new bootstrap.Popover(popoverTriggerEl)
		})
	</script>
	<script>
		$(document).ready(function(){
			$(".collapse.show").each(function(){
				$(this).prev(".card-header").find(".fa-solid").addClass("fa-minus").removeClass("fa-plus");
			});
			$(".collapse").on('show.bs.collapse', function(){
				$(this).prev(".card-header").find(".fa-solid").removeClass("fa-plus").addClass("fa-minus");
			}).on('hide.bs.collapse', function(){
				$(this).prev(".card-header").find(".fa-solid").removeClass("fa-minus").addClass("fa-plus");
			});
		});
	</script>
	<script>
		$('.collapse').on('shown.bs.collapse', function(e) {
			var $card = $(this).closest('.card');
			$('html,body').animate({
				scrollTop: $card.offset() .top-70
			}, 500);
		});
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('website.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lsio3bqwsusv/public_html/icl-fincorp/resources/views/website/contact-us.blade.php ENDPATH**/ ?>