        <?php $__env->startSection('styles'); ?>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Brand</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Products</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Brand</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['brand-create','brand-edit'])): ?>
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Brand</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="brand_id" name="brand_id" type="hidden" value="">
                                                    
                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Brand Name *</label>
                                                        <input data-parsley-required-message="Brand Name English Required" type="text" class="form-control" name="brand_name_en" id="brand_name_en"
                                                            value="" required>
                                                            
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Brand Name Arabic*</label>
                                                        <input data-parsley-required-message="Brand Name Arabic Required" type="text" class="form-control" name="brand_name_ar" id="brand_name_ar"
                                                            value="" required>
                                                            
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Brand Icon (<?php echo e(str_replace(',', 'x', env('BRANDIMAGESIZE'))); ?>px) *</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="image" id="image"
                                                            value="" >
                                                    </div>
                                                </div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand-create')): ?>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('<?php echo e(url(env('ADMIN_ROUTE').'/add_brand')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand-edit')): ?>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('<?php echo e(url(env('ADMIN_ROUTE').'/update_brand')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                                <?php endif; ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             <?php endif; ?>
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand-list')): ?>
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Brands</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                             <table  class="table table-bordered text-nowrap border-bottom dataTable no-footer " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Brand Name</th>
                                                        <th class="wd-15p border-bottom-0">Brand Name Arabic</th>
                                                        <th class="wd-15p border-bottom-0">Icon</th>
                                                        <th class="wd-15p border-bottom-0">Added By</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                    
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        <?php endif; ?>
                        <!-- End Row -->

                         <!-- Modal -->
               


                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the Brand ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        

            <?php $__env->stopSection(); ?>
              <?php $__env->startSection('scripts'); ?>  

   
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css?v3')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
 
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    var admin_route="/<?php echo e(env('ADMIN_ROUTE')); ?>";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,1],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,2,3,4,5]},
           {"className": "text-left", "targets": []}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  admin_route+"/brand_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "brand_id", "name": "brand_id"},
                  {"data": "brand_name", "name": "brand_name"},
                  {"data": "brand_name_ar", "name": "brand_name_ar"},
                  {"data": "created_at", "name": "created_at"},
                  {"data": "name", "name": "name"},
                  {"data": "brand_id", "name": "brand_id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          if(aData.brand_image=="" || aData.brand_image==null){aData.brand_image="no_image.png";}
          var image='<a href="/uploads/brand_image/'+aData.brand_image+'" target="_blank"><img style="width:90px; height:30px" src="/uploads/brand_image/'+aData.brand_image+'"></a>';
            //Edit Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand-edit')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.brand_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            <?php endif; ?>
            //Delete Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand-delete')): ?>
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.brand_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            <?php endif; ?>
            $('td:eq(0)', nRow).html(index);
            $('td:eq(3)', nRow).html(image);
            $('td:eq(5)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: admin_route+'/edit_brand',
                    success: function (result) {
                        $('#brand_id').val(result.brand_id);
                        $('#brand_name_en').val(result.brand_name);
                        $('#brand_name_ar').val(result.brand_name_ar);

                        $('#edimg').show();
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#brand_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#brand_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: admin_route+'/delete_brand',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################


        </script>
        <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Laravel\Ginger\pioneer_dental\resources\views/admin/brand/index.blade.php ENDPATH**/ ?>