        <?php $__env->startSection('styles'); ?>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">Category</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                         <li class="breadcrumb-item"><a href="javascript:void(0)">Products</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Category</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['category-create','category-edit'])): ?>
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add Category</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="category_id" name="category_id" type="hidden" value="">
                                                    
                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Category Name *</label>
                                                        <input data-parsley-required-message="Category Name English Required" type="text" class="form-control" name="category_name" id="category_name"
                                                            value="" required>
                                                            
                                                    </div>
                                                    
                                        <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">Category Description *</label>
                                            
                                            <textarea  data-parsley-required-message="Category Description Required" class="form-control" name="category_description" id="category_description" value="" required></textarea>            
                                   
                                            </div>
                                                    
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Category Image (<?php echo e(env('CATEGORYIMAGESIZE')); ?>px)</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="image" id="image"
                                                            value="" >
                                                    </div>
                                                    
                                                       <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">Category Banner (<?php echo e(env('CATEGORYBANNERESIZE')); ?>px)</label>
                                                        <input type="file" data-parsley-required-message="" class="form-control custom-input-file" name="category_banner" id="category_banner"
                                                            value="" >
                                                    </div>
                                                    
                                                </div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-create')): ?>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('<?php echo e(url('/add_category')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('<?php echo e(url('/update_category')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                                <?php endif; ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             <?php endif; ?>
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-list')): ?>
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View Categories</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                             <table  class="table table-bordered text-nowrap border-bottom dataTable no-footer " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Name</th>
                                                        <th class="wd-15p border-bottom-0">Icon</th>
                                                        <th class="wd-15p border-bottom-0">Banner</th>
                                                        <th class="wd-15p border-bottom-0">Added By</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                    
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        <?php endif; ?>
                        <!-- End Row -->

                         <!-- Modal -->
               


                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the category ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                                  
            <div class="modal fade" id="scrollingmodal" tabindex="-1" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" style="font-weight: bold;" id="view_modal_title">View Category</h5>
                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                    </div>
                    <div class="modal-body"  id="view_modal_body">
                        
                    </div>
                    <div class="modal-footer">
                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
            
                        

                        
                        

            <?php $__env->stopSection(); ?>
              <?php $__env->startSection('scripts'); ?>  

   
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css?v3')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
 
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,2,3,4,5]},
           {"className": "text-left", "targets": []}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  "/category_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "category_id", "name": "category_id"},
                  {"data": "category_name", "name": "category_name"},
                  {"data": "created_at", "name": "created_at"},
                  {"data": "category_banner", "name": "category_banner"},
                  {"data": "name", "name": "name"},
                  {"data": "category_id", "name": "category_id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          //category Icon Section
          if(aData.category_image=="" || aData.category_image==null){aData.category_image="no_image.png";}
          var image='<a href="/uploads/category_images/'+aData.category_image+'" target="_blank"><img style="width:39px; height:54px" src="/uploads/category_images/'+aData.category_image+'"></a>';
          //Category banner Section
             if(aData.category_banner=="" || aData.category_banner==null){aData.category_banner="no_image.jpeg";}
             var category_banner='<a href="/uploads/category_banner/'+aData.category_banner+'" target="_blank"><img style="width:95px; height:45px" src="/uploads/category_banner/'+aData.category_banner+'"></a>';
              //view Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-list')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=view('+aData.category_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class="fe fe-eye"> </span></button>';
            <?php endif; ?>
            //Edit Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-edit')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.category_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            <?php endif; ?>
            //Delete Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category-delete')): ?>
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.category_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            <?php endif; ?>
            $('td:eq(0)', nRow).html(index);
            $('td:eq(2)', nRow).html(image);
            $('td:eq(3)', nRow).html(category_banner);
            $('td:eq(5)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: '/edit_category',
                    success: function (result) {
                        $('#category_id').val(result.category_id);
                        $('#category_name').val(result.category_name);
                        $('#category_description').val(result.category_description);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#category_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#category_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/delete_category',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################

    //###########################View Section ####################
    function view(id){
          $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/view_category',
                        success: function (result) {
                             $('#view_modal_body').html(result);
                           $('#scrollingmodal').modal('show');
                        
                        }
                    }) 
        
        
    }
    
    
    //#############################End Of View Section############
        </script>
        <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deltaqatar/public_html/admin/resources/views/admin/category/index.blade.php ENDPATH**/ ?>