        <?php $__env->startSection('styles'); ?>

        <?php $__env->stopSection(); ?>

            <?php $__env->startSection('content'); ?>

                             <!-- PAGE-HEADER -->
                            <div class="page-header">
                                <h1 class="page-title">News</h1>
                                <div>
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">News</li>
                                    </ol>
                                </div>
                            </div>
                            <!-- PAGE-HEADER END -->

                            <!-- ROW-1 OPEN -->
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['news-create','news-edit'])): ?>
                            <div class="row">
                                <div class="col-lg-12 col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">Add News</h3>
                                        </div>
                                        <div class="card-body">
                                                <form method="POST" id="createForm" class="myform" enctype="multipart/form-data">  
                                                    <input id="csrf_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                                                    <input id="news_id" name="news_id" type="hidden" value="">
                                                    
                                                    <?php echo csrf_field(); ?>
                                                <div class="form-row">
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">News Heading *</label>
                                                        <input data-parsley-required-message="Heading  Required" type="text" class="form-control" name="news_heading" id="news_heading"
                                                            value="" required>
                                                            
                                                    </div>
                                                    
                                                        <div class="col-xl-4 mb-3">
                                                            <label for="validationTooltip02">News Description</label>
                                                            <textarea class="form-control" name="news_description" id="news_description" value=""></textarea>
                                                        </div>
                                                        
                                                        
                                                       <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip01">News Link (eg:https://www.yourlink.com) *</label>
                                                        <input data-parsley-required-message="Link  Required" type="text" class="form-control" name="news_link" id="news_link"
                                                            value="" required>
                                                            
                                                    </div>
                                                    <div class="col-xl-4 mb-3">
                                                        <label for="validationTooltip02">News Image (<?php echo e(env('NEWSIMAGESIZE')); ?>px) *</label>
                                                        <input type="file"  required="required" data-parsley-required-message="News Image Required" class="form-control custom-input-file" name="image" id="image"
                                                            value="" >
                                                    </div>
                                                </div>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-create')): ?>
                                                <a id="create_btn" href="#" onclick="createOrUpdate('<?php echo e(url('/add_news')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Save</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-edit')): ?>
                                                <a  id="update_btn" style="display: none" href="#" onclick="createOrUpdate('<?php echo e(url('/update_news')); ?>', 'createForm', '', 'table_datatable','')" class="btn custom-btn-success"><i class="fa fa-save"></i> Update</a>
                                                <?php endif; ?>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                             <?php endif; ?>
                            <!-- /ROW-1 CLOSED -->

                               <!-- Row -->
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-list')): ?>
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">View News</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                             <table  class="table table-bordered text-nowrap border-bottom dataTable no-footer " style="width: 100% !important;" id="table_datatable">
                                                <thead class="text-center">
                                                    <tr>
                                                        <th class="wd-15p border-bottom-0">#</th>
                                                        <th class="wd-15p border-bottom-0">Heading</th>
                                                        <th class="wd-15p border-bottom-0">Link</th>
                                                        <th class="wd-15p border-bottom-0">Added By</th>
                                                        <th class="wd-10p border-bottom-0">Actions</th>
                                                    </tr>
                                                </thead>
                                               
                                            </table>
                                    
                                            <div class="col-sm-12 col-md-12">                                             
                                        </div>
                                        </div>
                                    </div>
                        

                                </div>
                               
                            </div> 
                        </div> 
                        <?php endif; ?>
                        <!-- End Row -->

                         <!-- Modal -->
               


                        <div class="modal  fade" id="smallmodal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Delete</h5>
                                        <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                            </button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Do you want to delete the News ?</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                        <button onclick="delete_item()" class="btn custom-btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                        
                             <!--###########################view Model######################-->
                                <div class="modal fade" id="largemodal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-md" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">News  Details</h5>
                                    <button class="btn-close text-danger" data-bs-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span>
                                        </button>
                                </div>
                                <div class="modal-body" id="news_view_modal_body">
                                 
                                </div>
                                <div class="modal-footer">
                                    <button class="btn custom-btn-warning" data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--###########################End Of  View Model#######################-->

                        
                        

            <?php $__env->stopSection(); ?>
              <?php $__env->startSection('scripts'); ?>  

   
   <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.css?v3')); ?>">
   <script src="<?php echo e(asset('assets/jquery-datatable/jquery.dataTables.js')); ?>"></script>
 
        <script>
    var token = $("meta[name=csrf-token]").attr("content");  
    var datatable_name="table_datatable";
    $('#table_datatable').DataTable({
        "responsive": true,
       "serverSide": true,
       "ordering": true,
       "searching": true,
       "bLengthChange": true,
       "info":false,
       "bSort": true,
       "order": [
           [0, 'desc']
       ],
       "columnDefs": [{
               "targets": [0,4],
               "orderable": true
           },
           {"className": "text-center", "targets": [0,3,4]},
           {"className": "text-left", "targets": []}
           
       ],
       "displayLength":10,
       "ajax": {
           "url":  "/news_datatable",
           "type": "post",
           "data": function (data) {
                data._token = token;
              
               return data;
  
           }
       }, "AutoWidth": true,
       "columns": [
                  {"data": "news_id", "name": "news_id"},
                  {"data": "news_heading", "name": "news_heading"},
                  {"data": "news_link", "name": "news_link"},
                  {"data": "name", "name": "name"},
                  {"data": "news_id", "name": "news_id"},
                   ],
      
      "fnCreatedRow": function (nRow, aData, iDataIndex) {
          var info = this.dataTable().api().page.info();
          var page = info.page;
          var length = info.length;
          var index = (page * length + (iDataIndex + 1));
          var action="";
          
          //View Action 
                  var action=action+'&nbsp;<button title="Track"  onclick=View('+aData.news_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-success"><span class=" fa fa-eye"> </span></button>'

            //Edit Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-edit')): ?>
            var action=action+'&nbsp;<button title="Edit"  onclick=edit('+aData.news_id+') id="bEdit" type="button" class="btn btn-sm custom-btn-info"><span class="fe fe-edit"> </span></button>';
            <?php endif; ?>
            //Delete Action
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-delete')): ?>
            var action=action+'&nbsp;<button title="Delete" onclick="delete_modal('+aData.news_id+')" id="bDel" type="button" class="btn  btn-sm custom-btn-danger"><span class="fe fe-trash-2"> </span></button>';
            <?php endif; ?>
            $('td:eq(0)', nRow).html(index);
            $('td:eq(4)', nRow).html(action);
 }
 });

       // #################### Edit Section ############################
                function edit(id){
                $.ajax({
                    type: 'POST',
                    data: {"_token": token,"id": id},
                    url: '/edit_news',
                    success: function (result) {
                        $('#news_id').val(result.news_id);
                        $('#news_heading').val(result.news_heading);
                        $('#news_description').val(result.news_description);
                        $('#news_link').val(result.news_link);
                        $('#create_btn').hide();
                        $('#update_btn').show();
                        $("#image").attr("required", false);
                        $('#back-to-top').click();
                        
                        }
                })
                }
      // #################### End Of Edit Section ####################
     // #################### Delete Section ##########################
                    function delete_modal(id){
                    $('#news_id').val(id);
                    $('#smallmodal').modal('show');
                    }
                    function delete_item(){
                    var id=$('#news_id').val();
                    $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/delete_news',
                        success: function (result) {
                        $('#smallmodal').modal('hide');
                        toast(result,datatable_name);
                        }
                    })
                    }
     // #################### End Of Delete Section ##################


 function View(id){
           $.ajax({
                        type: 'POST',
                        data: {"_token": token,"id": id},
                        url: '/view_news',
                        success: function (result) {
                            $('#news_view_modal_body').html(result); 
                            $('#largemodal').modal('show');
                        }
                    })

 }
 

        </script>
        <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deltaqatar/public_html/admin/resources/views/admin/news/index.blade.php ENDPATH**/ ?>