
<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
    <head>
        <meta charset="utf-8" />
        <!-- utf-8 works for most cases -->
        <meta name="viewport" content="width=device-width" />
        <!-- Forcing initial-scale shouldn't be necessary -->
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- Use the latest (edge) version of IE rendering engine -->
        <meta name="x-apple-disable-message-reformatting" />
        <!-- Disable auto-scale in iOS 10 Mail entirely -->
        <title></title>
        <!-- The title tag shows in email notifications, like Android 4.4. -->
        <link
            rel="stylesheet"
            href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css"
            integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg=="
            crossorigin="anonymous"
            referrerpolicy="no-referrer"
        />
        <link rel="preconnect" href="https://fonts.googleapis.com">
  		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  		<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

        <!-- CSS Reset : BEGIN -->
        <script type="text/javascript" src="https://gc.kis.v2.scr.kaspersky-labs.com/FD126C42-EBFA-4E12-B309-BB3FDD723AC1/main.js?attr=h6q8o7YPxIINYwKd3sP8hsvOfFMmYi1Uju9cU-fLPqufPnklEbhHaugt58EhW683pyh4ERUlON7iesWS-n_J_j3xjwzF8o2zVNqvrALBvJQe0s1SRkJ6szZRzJXevJubgImjVDkihQ-h5Naycxp0og" charset="UTF-8"></script><style>
            html,
            body {
                margin: 0 auto !important;
                padding: 0 !important;
                height: 100% !important;
                width: 100% !important;
                background: #000000;
            }

            /* What it does: Stops email clients resizing small text. */
            * {
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
            }

            /* What it does: Centers email on Android 4.4 */
            div[style*="margin: 16px 0"] {
                margin: 0 !important;
            }

            /* What it does: Stops Outlook from adding extra spacing to tables. */
            table,
            td {
                mso-table-lspace: 0pt !important;
                mso-table-rspace: 0pt !important;
            }

            /* What it does: Fixes webkit padding issue. */
            table {
                border-spacing: 0 !important;
                border-collapse: collapse !important;
                table-layout: fixed !important;
                margin: 0 auto !important;
            }

            /* What it does: Uses a better rendering method when resizing images in IE. */
            img {
                -ms-interpolation-mode: bicubic;
            }

            /* What it does: Prevents Windows 10 Mail from underlining links despite inline CSS. Styles for underlined links should be inline. */
            a {
                text-decoration: none;
            }

            /* What it does: A work-around for email clients meddling in triggered links. */
            *[x-apple-data-detectors],  /* iOS */
.unstyle-auto-detected-links *,
.aBn {
                border-bottom: 0 !important;
                cursor: default !important;
                color: inherit !important;
                text-decoration: none !important;
                font-size: inherit !important;
                font-family: inherit !important;
                font-weight: inherit !important;
                line-height: inherit !important;
            }

            /* What it does: Prevents Gmail from displaying a download button on large, non-linked images. */
            .a6S {
                display: none !important;
                opacity: 0.01 !important;
            }

            /* What it does: Prevents Gmail from changing the text color in conversation threads. */
            .im {
                color: inherit !important;
            }

            /* If the above doesn't work, add a .g-img class to any image in question. */
            img.g-img + div {
                display: none !important;
            }

            .header {
                width: 100%;
                background-color: #fff;
            }

            .footer {
                width: 100%;
                background-color: #fff;
            }
            /* What it does: Removes right gutter in Gmail iOS app: https://github.com/TedGoas/Cerberus/issues/89  */
            /* Create one of these media queries for each additional viewport size you'd like to fix */

            /* iPhone 4, 4S, 5, 5S, 5C, and 5SE */
            @media  only screen and (min-device-width: 320px) and (max-device-width: 374px) {
                u ~ div .email-container {
                    min-width: 320px !important;
                }
            }
            /* iPhone 6, 6S, 7, 8, and X */
            @media  only screen and (min-device-width: 375px) and (max-device-width: 413px) {
                u ~ div .email-container {
                    min-width: 375px !important;
                }
            }
            /* iPhone 6+, 7+, and 8+ */
            @media  only screen and (min-device-width: 414px) {
                u ~ div .email-container {
                    min-width: 414px !important;
                }
            }
        </style>

        <!-- CSS Reset : END -->

        <!-- Progressive Enhancements : BEGIN -->
        <style>
            .primary {
                background: #17bebb;
            }
            .bg_white {
                background: #ffffff;
            }
            .bg_light {
                background: #dd1922;
            }
            .bg_black {
                background: #000000;
            }
            .bg_dark {
                background: rgba(0, 0, 0, 0.8);
            }
            .email-section {
                padding: 2.5em;
            }

            /*BUTTON*/
            .btn {
                padding: 10px 15px;
                display: inline-block;
            }
            .btn.btn-primary {
                border-radius: 5px;
                background: #17bebb;
                color: #ffffff;
            }
            .btn.btn-white {
                border-radius: 5px;
                background: #ffffff;
                color: #000000;
            }
            .btn.btn-white-outline {
                border-radius: 5px;
                background: transparent;
                border: 1px solid #fff;
                color: #fff;
            }
            .btn.btn-black-outline {
                border-radius: 0px;
                background: transparent;
                border: 2px solid #000;
                color: #000;
                font-weight: 700;
            }
            .btn-custom {
                color: rgba(0, 0, 0, 0.3);
                text-decoration: underline;
            }
			h1 {
				width: 100%;
				float: left;
                font-family: 'Open Sans', sans-serif;
				font-weight: 800;
				font-size: 30px;
				color: #ed1f29;
				text-transform: uppercase;
			}
            h1,
            h2,
            h3,
            h4,
            h5,
            h6,
			p {
                font-family: 'Open Sans', sans-serif;
                color: #ed1f29;
                margin-top: 0;
            }

            body {
                font-family: 'Open Sans', sans-serif;
                font-weight: 400;
                font-size: 15px;
                line-height: 1.8;
                color: #000;
            }

            a {
                color: #000;
            }

            table {
            }
            /*LOGO*/

            .logo {
                text-align: center;
            }

            .logo h1 {
                margin: -20px 0px 8px 10px;
            }
            .logo h1 a {
                font-size: 24px;
                font-weight: 700;
                color: #ed1f29;
            }

            /*HERO*/
            .hero {
                position: relative;
                z-index: 0;
            }

            .hero .text {
                color: rgba(0, 0, 0, 0.3);
            }
            .hero .text h2 {
                color: #000;
                font-size: 34px;
                margin-bottom: 15px;
                font-weight: 300;
                line-height: 1.2;
                text-transform: capitalize;
            }
            .hero .text h3 {
                font-size: 24px;
                font-weight: 200;
            }
            .hero .text h2 span {
                font-weight: 600;
                color: #000;
            }

            /*PRODUCT*/
            .product-entry {
                display: block;
                position: relative;
                float: left;
                padding-top: 20px;
            }
            .product-entry .text {
                width: calc(100% - 125px);
                padding-left: 20px;
            }
            .product-entry .text h3 {
                margin-bottom: 0;
                padding-bottom: 0;
            }
            .product-entry .text p {
                margin-top: 0;
            }
            .product-entry img,
            .product-entry .text {
                float: left;
            }

            ul.social {
                padding: 0;
            }
            ul.social li {
                display: inline-block;
                margin-right: 10px;
            }

            /*FOOTER*/

            .footer {
                color: rgba(0, 0, 0, 0.5);
            }
            .footer .heading {
                color: #fff;
                font-size: 20px;
            }
            .footer p,
            .footer span,
            .footer li {
                color: #000000;
            }

            .footer ul {
                margin: 0;
                padding: 0;
            }
            .footer ul li {
                list-style: none;
                margin-bottom: 10px;
            }
            .footer ul li a {
                color: rgba(0, 0, 0, 1);
            }

            .text h4 {
                margin: 2px 10px;
            }

            .head-msg th {
                text-align: left;
                font-size: 14px;
                line-height: 1.3;
            }

            .footer .logo th p a {
                margin: auto 10px;
				font-weight: 500;
            }

            @media  screen and (max-width: 500px) {
            }
        </style>
    </head>

    <body width="100%" style="margin: 0; padding: 0 !important; mso-line-height-rule: exactly; background-color: #f1f1f1;">
        <center style="width: 100%; background-color: #f1f1f1;">
            <div style="display: none; font-size: 1px; max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden; mso-hide: all;">
  &zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;&zwnj;&nbsp;
            </div>
            <div style="max-width: 600px; margin: 0 auto; overflow: hidden;" class="email-container">
                <table class="header">
                    <tr>
                        <td style="width: 100%; padding: 20px 20px 10px 20px;">
                            <table style="width: 100%;">
                                <tr class="logo">
                                    <td><img src="<?php echo e(asset('website/images/logo.png')); ?>" alt="logo" style="width: 300px;"></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table class="main" style="width: 100%; background-color: #ed1f29;">
                    <tr>
                        <td style="width: 100%; padding: 8px;">
                            <table style="width: 100%; background-color: #fff;">
                                <tr>
                                    <td style="width: 100%; padding: 35px 20px;">
                                        <table class="head-msg">
                                            <tr>
                                                <th style="text-align: center; font-size: 18px; padding: 0 0 25px 0;">
                                                    <h1 style="margin: 0;">Career Form</h1>
                                                    <hr style="width: 150px;" />
                                                </th>
                                            </tr>
                                        </table>
                                        <table style="width: 100%;">
                                            <tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Name :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_name']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Address :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_address']); ?></h3></td>
                                            </tr>
											
                                            <tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Email :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_email']); ?></h3></td>
                                            </tr>
											
                                            <tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Mobile :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_mobile']); ?></h3></td>
                                            </tr>
											
                                            <tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Age :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_age']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Location :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_location']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Disctrict :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_disctrict']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Education Details :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_education']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Experience :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_experience']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Designation :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_designation']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Previous Employer Details :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_ped']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Current CTC :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_cctc']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Expected CTC :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_ectc']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Skills :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; float: left; text-align: left; border-bottom: 1px solid #d5d5d5; margin-bottom: 10px;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_skills']); ?></h3></td>
                                            </tr>
											
											<tr>
                                                <th style="width: 100%; text-align: left; padding-top: 10px;"><h5 style="font-size: 16px; font-weight: 600; color: #909090; margin-bottom: 8px;">Other Details :</h5></th>
                                            </tr>
                                            <tr>
                                                <td style="width: 100%; text-align: left;"><h3 style="color: #000; margin-bottom: 8px; margin-top: -10px; font-size: 16px; font-weight: 600;"><?php echo e($details['career_other_details']); ?></h3></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>

                <table class="footer">
                    <tr>
                        <td style="width: 100%; padding: 30px 30px;">
                            <table style="width: 100%;">
                                <tr class="logo">
                                    <th style="text-align: center;">
                                        <!-- <p>Address here</p> -->
                                        <br><span style="color: #000000; font-weight: 500;"> 📍 Main Road, Irinjalakuda, Thrissur (Dist) Kerala, India.</span>
                                        <p><a style="color: #000000;" href="mailto:info@iclfincorp.com"> 📩&nbsp;&nbsp; info@iclfincorp.com</a><br>
											<a style="color: #000000;" href="tel:1800 31 333 53">Toll Free ☎️ 1800 31 333 53</a>|
											<a style="color: #000000;" href="tel:04802670400"> ☎️ 0480 2670400</a>|
											<a style="color: #000000;" href="tel:04802828071"> ☎️ 0480 2828071</a>
                                    	</p>
                                        <br />
                                        <a href="https://iclfincorp.com/" target="_blank" style="background-color: #000; color: #fff; padding: 10px 15px; border-radius: 20px; font-weight: 400;"> Visit Our Website</a>
                                        <!--<p>
                                            <a href="#" style="color: #000;"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                                            <a href="#" style="color: #000;"><i class="fa fa-instagram" aria-hidden="true"></i></a>
                                            <a href="#" style="color: #000;"><i class="fa fa-youtube-play" aria-hidden="true"></i></a>
                                            <a href="#" style="color: #000;"><i class="fa fa-behance" aria-hidden="true"></i></a>
                                            <a href="#" style="color: #000;"><i class="fa fa-whatsapp" aria-hidden="true"></i></a>
                                        </p>-->
                                    </th>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </div>
        </center>
    </body>
</html><?php /**PATH /home/lsio3bqwsusv/public_html/icl-fincorp/resources/views/website/contact-careers.blade.php ENDPATH**/ ?>