<?php
  $state_avail = \App\Models\AvailableLocationModel::pluck('avail_state')->first();
  $services_drp = \App\Models\ServiceModel::where('service_status',0)->orderby('service_id','ASC')->get();
  $services_new_footer = \App\Models\ServiceModel::where('service_status',0)->first();
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('website/images/favicon.webp')); ?>" type="image/x-icon">
  <title>ICL Fincorp</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/main-style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/fontawesome/css/all.min.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <!-- <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet"> -->

  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/aos.2.3.1.css')); ?>">
  
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('website/css/swiper-bundle.min.css')); ?>">
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
  <?php echo $__env->yieldPushContent('custom-css'); ?>
</head>
<body>
<!--************************************* header *************************************-->
  <section class="top py-lg-2">
    <div class="container-xl d-flex justify-content-between">
      <div class="top_ph d-flex align-items-center">
        <a class="d-flex align-items-center" href="/branches/<?php echo e(str_replace(' ','-',$state_avail)); ?>"><i class="fa-solid fa-location-dot me-lg-2 trs"></i><span class="float-start">Find Our Location</span></a>
        <div class="vr float-start bg-white mx-3 opacity-50"></div>
        <a class="d-flex align-items-center" href="tel:1800 31 333 53"><i class="fa-solid fa-mobile-screen-button me-lg-2 trs"></i><span class="float-start">1800 31 333 53</span></a>
        <div class="vr float-start bg-white mx-3 opacity-50"></div>
        <a class="d-flex align-items-center" href="mailto:info@iclfincorp.com"><i class="fa-solid fa-envelope-open me-lg-2 trs"></i><span class="float-start">info@iclfincorp.com</span></a>
      </div>
      <div class="social_media float-start align-items-center d-none d-sm-flex d-md-flex d-lg-flex d-xl-flex d-xxl-flex">
        <span class="me-3">Follow us:</span>
        <a class="trs fb" href="https://www.facebook.com/iclfincorp" title="Facebook" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
                <a class="trs im" href="https://www.instagram.com/iclfincorp/" title="Instagram" target="_blank"><i class="fa-brands fa-instagram"></i></a>
                <!--<a class="trs tx" href="javascript:void(0)" title="Twitter" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
                <a class="trs in" href="javascript:void(0)" title="Linkedin" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>-->
                <a class="trs yt" href="https://www.youtube.com/channel/UCdG9r8ROaPrKycOtEm8zcHg" title="YouTube" target="_blank"><i class="fa-brands fa-youtube"></i></a>
      </div>
      <div class="d-flex d-sm-flex d-md-flex d-lg-flex d-xl-none d-xxl-none float-start">
        <div class="float-start">
          <button class="btn border-0 trs" type="button" data-bs-toggle="offcanvas" data-bs-target="#menu_search"><i class="fa-solid fa-magnifying-glass text-white"></i></button>
          <div class="offcanvas offcanvas-top" id="menu_search">
            <div class="offcanvas-body d-flex justify-content-between align-items-center">
              <form class="input-group mx-auto" role="form">
                <input type="text" class="form-control border-0" placeholder="Search">
                <button class="btn border-0 trs" type="submit"><i class="fa-solid fa-magnifying-glass text-white"></i></button>
              </form>
              <button type="button" class="btn-close float-end ms-4" data-bs-dismiss="offcanvas"></button>
            </div>
          </div>
        </div>
        <div class="vr float-start bg-white mx-3 opacity-50 d-block d-sm-block d-md-block d-lg-block d-xl-none d-xxl-none h-100"></div>
        <button class="navbar-toggler menu_icon" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
          <span class="w-50 trs"></span><span class="w-75 trs"></span><span class="w-100 trs"></span>
        </button>
      </div>
    </div>
  </section>
  <section class="header align-items-center">
    <div class="container-xl d-flex justify-content-between py-lg-3 py-2 px-3">
      <div class="logo trs"><a href="/"><img class="img-fluid trs" src="<?php echo e(asset('website/images/logo.svg')); ?>" alt="logo"></a></div>
      <div class="d-flex flex-wrap align-items-center">
        <div class="header_opening_hours text-end d-none d-sm-none d-md-block d-lg-block d-xl-block d-xxl-block">
          Opening Hours: Monday - Saturday<br>
          <span>9:00 am to 5:30 pm</span>
        </div>
        <div class="d-flex d-sm-flex d-md-none d-lg-none d-xl-none d-xxl-none">
          <a href="javascript:void(0)" title="Opening Hours" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="bottom" data-bs-content="Mon-Sat - 9:00 am to 5:30 pm"><i class="fa-solid fa-clock text-danger"></i></a>
          <div class="vr bg-black mx-3 opacity-50 align-self-center h-100"></div>
          <a href="javascript:void(0)"><i class="fa-solid fa-right-to-bracket text-danger"></i></a>
        </div>
        <div class="vr float-start bg-black mx-4 opacity-100 align-self-center h-50 d-none d-sm-none d-md-block d-lg-block d-xl-block d-xxl-block"></div>
        <a class="send_btn trs d-none d-sm-none d-md-block d-lg-block d-xl-block d-xxl-block" href="javascript:void(0)">Login <i class="fa-sharp fa-solid fa-arrow-right-long ms-5"></i></a>
      </div>
    </div>
  </section>
  <section class="container">
    <div class="position-relative">
      <div class="menu_bg sticky-top w-100 d-flex justify-content-between">
        <nav class="navbar navbar-expand-xl" aria-label="Offcanvas navbar large">
          <div class="logo me-5 trs">
            <a href="/"><img class="img-fluid trs" src="<?php echo e(asset('website/images/logo.svg')); ?>" alt="logo"></a>
          </div>
          <button class="navbar-toggler menu_icon" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
            <span class="w-50 trs"></span><span class="w-75 trs"></span><span class="w-100 trs"></span>
          </button>
          <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar">
            <div class="offcanvas-header py-1 bg-light">
              <button type="button" class="menu-close" data-bs-dismiss="offcanvas" aria-label="Close"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <div class="offcanvas-body">
              <ul class="navbar-nav">
                <li class="nav-item <?php if(Request::segment(1)==''): ?> active <?php endif; ?>"><a class="nav-link" href="/">Home</a></li>
                <li class="nav-item dropdown <?php if(Request::segment(1)=='overview' || request::segment(1)=='profile-of-cmd' || request::segment(1)=='board-of-directors'): ?> active <?php endif; ?>"><a class="nav-link dropdown-toggle" href="javascript:void(0)">About Us</a>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="/overview">Overview</a></li>
                    <li><a class="dropdown-item" href="/profile-of-cmd">Profile of CMD</a></li>
                    <li><a class="dropdown-item" href="/board-of-directors">Board of Directors</a></li>
                    <!--<li class="dropdown"><a class="dropdown-item dropdown-toggle" href="javascript:void(0)">Our Group of Companies</a>
                      <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="javascript:void(0)">ICL Tours and Travels LLC</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0)">ICL Tours & Travels (P)Ltd</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0)">ICL Nidhi Ltd</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0)">ICL Cultural & Charitable Trust</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0)">ICL Medilab Pvt Ltd</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0)">Tuline</a></li>
                      </ul>
                    </li>-->
                  </ul>
                </li>
                <!-- <li class="nav-item dropdown"><a class="nav-link dropdown-toggle" href="javascript:void(0)">Policy</a>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="javascript:void(0)">Quality Policy</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0)">Fair Practices Code</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0)">Resource Planning</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0)">Remuneration Policy</a></li>
                    <li><a class="dropdown-item" href="javascript:void(0)">Ombudsman Policy</a></li>
                  </ul>
                </li> -->
                <li class="nav-item dropdown <?php if(Request::segment(1)=='services'): ?> active <?php endif; ?>"><a class="nav-link dropdown-toggle" href="javascript:void(0)">Our Services</a>
                  <ul class="dropdown-menu">
                    <?php $__currentLoopData = $services_drp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $drp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a class="dropdown-item" href="/services/<?php echo e($drp->service_link); ?>"><?php echo e($drp->service_name); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
                </li>
                <li class="nav-item dropdown <?php if(Request::segment(1)=='credit-rating' || request::segment(1)=='notice-to-investors' || request::segment(1)=='annual-reports' || Request::segment(1)=='debentures' || request::segment(1)=='disclosure' || request::segment(1)=='policies-and-codes'): ?> active <?php endif; ?>"><a class="nav-link dropdown-toggle" href="javascript:void(0)">Investors</a>
                  <ul class="dropdown-menu">
                    
                    <li><a class="dropdown-item" href="/notice-to-investors">Notice to Investors</a></li>

                    <li><a class="dropdown-item" href="/annual-reports">Annual Reports</a></li>
                    <li><a class="dropdown-item" href="/credit-rating">Credit Rating</a></li>
                    
                    <li><a class="dropdown-item" href="/debentures">Debentures</a></li>
                    
                    <li><a class="dropdown-item" href="/disclosure">Disclosures</a></li>
                    <li><a class="dropdown-item" href="/policies-and-codes">Policies and Codes</a></li>
                  </ul>
                </li>
                <li class="nav-item <?php if(Request::segment(1)=='downloads'): ?> active <?php endif; ?>"><a class="nav-link" href="/downloads">Downloads</a>
                </li>
                <li class="nav-item <?php if(Request::segment(1)=='careers'): ?> active <?php endif; ?>"><a class="nav-link" href="/careers">Careers</a></li>
                <li class="nav-item dropdown <?php if(Request::segment(1)=='contact-us' || Request::segment(1)=='branches'): ?> active <?php endif; ?>"><a class="nav-link dropdown-toggle" href="javascript:void(0)">Contact Us</a>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="/contact-us">Contact Us</a></li>
                    
                    <li><a class="dropdown-item" href="/branches/<?php echo e(str_replace(' ','-',$state_avail)); ?>">Branches</a></li>
                  </ul>
                </li>
              </ul>
            </div>
          </div>
        </nav>
        <!-- <form class="menu_search input-group float-start d-none d-sm-none d-md-none d-lg-none d-xl-flex d-xxl-flex" role="form">
          <input type="text" class="form-control border-0" placeholder="Search">
          <button class="btn border-0 text-white trs" type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
        </form> -->
      </div>
    </div>
  </section>
<!--************************************* home *************************************-->

<?php echo $__env->yieldContent('content'); ?>

<!--************************************* footer *************************************-->
  <section class="footer_address">
    <div class="container">
      <div class="row">
        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12 footer_address_call_bg">
          <div class="footer_address_bg py-md-4">
            <div data-aos="fade-up" class="d-flex align-items-center w-100 float-start py-4 flex-lg-nowrap flex-wrap justify-content-center text-lg-start text-center">
              <span class="footer_address_call me-lg-2 me-0 mb-lg-0 mb-4"></span>
              <div class="w-100">
                <h5 class="mb-2">Have a Question? Call Us Now</h5>
                <a class="trs" href="tel:1800 31 333 53">1800 31 333 53</a>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12 footer_address_map_bg">
          <div class="footer_address_bg py-md-4">
            <div data-aos="fade-up" class="d-flex align-items-center w-100 float-start footer_address_border p-4 flex-lg-nowrap flex-wrap justify-content-center text-lg-start text-center">
              <span class="footer_address_map me-lg-2 me-0 mb-lg-0 mb-4"></span>
              <div class="w-100">
                <h5 class="mb-2">Our Address</h5>
                <a class="trs" href="/branches/<?php echo e(str_replace(' ','-',$state_avail)); ?>">Find Our Locations</a>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12 footer_address_mail_bg">
          <div class="footer_address_bg py-md-4">
            <div data-aos="fade-up" class="d-flex align-items-center w-100 float-start py-4 flex-lg-nowrap flex-wrap justify-content-center text-lg-start text-center">
              <span class="footer_address_mail me-lg-2 me-0 mb-lg-0 mb-4"></span>
              <div class="w-100">
                <h5 class="mb-2">Have a Question? Mail Us Now</h5>
                <a href="mailto:info@iclfincorp.com" class="trs">info@iclfincorp.com</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="footer">
    <div data-aos="fade-up" class="container">
      <div class="row footer_newsletter d-flex justify-content-between align-items-center pb-4">
        <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
          <p class="text-lg-start text-center mb-lg-0 mb-4"><i>Subscribe our newsletter to get updates about our service and offers.</i></p>
        </div>
        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
          <form class="footer_search input-group float-start" role="form">
            <input type="text" class="form-control border-0" placeholder="Enter your email address">
            <button class="btn text-white rounded-0 trs" type="submit">Subscribe</button>
          </form>
        </div>
      </div>
    </div>
    <div class="container">
      <div data-aos="fade-up" id="footer_accordion" class="row gx-lg-5 mt-lg-0 mt-4">
        <div class="card border-0 bg-transparent col-xxl-4 col-xl-4 col-lg-4 col-12 mb-3">
          <div class="card-header p-0 border-0 bg-transparent">
            <a class="d-lg-none d-block" data-bs-toggle="collapse" href="#footer_collapseOne">
              <h3 class="mb-3">About ICL Fincorp <i class="fa-solid fa-plus"></i></h3>
            </a>
            <h3 class="mt-5 mb-4 d-lg-block d-none">About ICL Fincorp</h3>
          </div>
          <div id="footer_collapseOne" class="collapse show" data-bs-parent="#footer_accordion">
            <div class="card-body w-100 float-start p-0">
              <h4>In the year 1991, the Company forayed into the non-banking financial sector (NBFC) with the approval of the Reserve Bank of India. Today, ICL Fincorp, is one of the leading Gold Loan  oriented  Non-Banking  Finance  Companies (NBFC) in South India. Few decades back on a strong launching in Chennai and Kerala,  ICL  Fincorp  has  expanded  its  operations in terms of business volume and also geographical reach.</h4>
            </div>
          </div>
        </div>
        <div class="col-xxl-5 col-xl-5 col-lg-5 col-12">
          <div class="row gx-sm-5 gx-0">
            <div class="card border-0 bg-transparent col-lg-6 col-12 mb-3">
              <div class="card-header p-0 border-0 bg-transparent">
                <a class="d-lg-none d-block" data-bs-toggle="collapse" href="#footer_collapseTwo">
                  <h3 class="mb-3">Useful Links <i class="fa-solid fa-plus"></i></h3>
                </a>
                <h3 class="mt-5 mb-4 d-lg-block d-none">Useful Links</h3>
              </div>
              <div id="footer_collapseTwo" class="collapse" data-bs-parent="#footer_accordion">
                <div class="card-body w-100 float-start p-0">
                  <ul>
                    <li><a class="trs <?php if(Request::segment(1)==''): ?> active <?php endif; ?>" href="/">Home</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='overview' || request::segment(1)=='profile-of-cmd' || request::segment(1)=='board-of-directors'): ?> active <?php endif; ?>" href="/overview">About Us</a></li>
                    <li><a class="trs" href="javascript:void(0)">Policy</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='services'): ?> active <?php endif; ?>" href="/services/<?php echo e($services_new_footer->service_link); ?>">Our Services</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='credit-rating' || request::segment(1)=='notice-to-investors' || request::segment(1)=='annual-reports' || Request::segment(1)=='debentures' || request::segment(1)=='disclosure' || request::segment(1)=='policies-and-codes'): ?> active <?php endif; ?>" href="/credit-rating">Investors</a></li>
                    <li><a class="trs" href="https://www.bseindia.com/" target="_blank">Stock Exchange</a></li>
                    <li><a class="trs" href="https://www.rbi.org.in/" target="_blank">RBI</a></li>
                  </ul>
                  <ul class="d-lg-none d-block">
                    <li><a class="trs" href="https://www.sebi.gov.in/" target="_blank">SEBI</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='downloads'): ?> active <?php endif; ?>" href="/downloads">Downloads</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='careers'): ?> active <?php endif; ?>" href="/careers">Careers</a></li>
                    <li><a class="trs" href="javascript:void(0)">Gallery</a></li>
                    <li><a class="trs" href="javascript:void(0)">News</a></li>
                    <li><a class="trs <?php if(Request::segment(1)=='contact-us' || Request::segment(1)=='branches'): ?> active <?php endif; ?>" href="/contact-us">Contact Us</a></li>
                    <li><a class="trs" href="javascript:void(0)">Terms &amp; Conditions</a></li>
                    <li><a class="trs" href="javascript:void(0)">Privacy Policy</a></li>
                  </ul>
                </div>
              </div>
            </div>
            <div class="card border-0 bg-transparent col-lg-6 col-12">
              <h3 class="mt-5 mb-4 d-lg-block d-none">Useful Links</h3>
              <div id="footer_collapseThree" class="collapse" data-bs-parent="#footer_accordion">
                <ul>
                  <li><a class="trs" href="https://www.sebi.gov.in/" target="_blank">SEBI</a></li>
                  <li><a class="trs <?php if(Request::segment(1)=='downloads'): ?> active <?php endif; ?>" href="/downloads">Downloads</a></li>
                  <li><a class="trs <?php if(Request::segment(1)=='careers'): ?> active <?php endif; ?>" href="/careers">Careers</a></li>
                  <li><a class="trs" href="javascript:void(0)">Gallery</a></li>
                  <li><a class="trs" href="javascript:void(0)">News</a></li>
                  <li><a class="trs <?php if(Request::segment(1)=='contact-us' || Request::segment(1)=='branches'): ?> active <?php endif; ?>" href="/contact-us">Contact Us</a></li>
                </ul>
              </div>
            </div>
          </div>
        </div>
        <div class="card border-0 bg-transparent col-xxl-3 col-xl-3 col-lg-3 col-12">
          <div class="card-header p-0 border-0 bg-transparent">
            <a class="d-lg-none d-block" data-bs-toggle="collapse" href="#footer_collapseFour">
              <h3 class="mb-3">Reach Us <i class="fa-solid fa-plus"></i></h3>
            </a>
            <h3 class="mt-5 mb-4 d-lg-block d-none">Reach Us</h3>
          </div>
          <div id="footer_collapseFour" class="collapse" data-bs-parent="#footer_accordion">
            <div class="card-body w-100 float-start p-0">
              <h5 class="mb-3">
                <span>Admin Office</span> <br>
                Main Road, Irinjalakuda, <br>
                Thrissur, Kerala, India.
              </h5>
              <h5 class="mb-3">
                <span>Registered Office</span> <br>
                VGP Complex, First Avenue, <br>
                Ashok Nagar, Chennai.
              </h5>
              <h5 class="mb-3">
                <span>Email:</span> <a href="mailto:info@iclfincorp.com" class="trs">info@iclfincorp.com</a><br>
                <span>Toll Free:</span> <a class="trs" href="tel:1800 31 333 53">1800 31 333 53</a><br>
                <span>Phone:</span> <a class="trs" href="tel:04802670400">0480&nbsp;2670400</a>, <a class="trs" href="tel:04802828071">0480&nbsp;2828071</a>, <a class="trs" href="tel:04802831305">0480&nbsp;2831305</a>
              </h5>
              <div class="social_media float-start align-items-center d-block d-sm-block d-md-none d-lg-none d-xl-none d-xxl-none">
                <span class="mb-3">Follow us:</span>
                <a class="trs fb" href="https://www.facebook.com/iclfincorp" title="Facebook" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
                <a class="trs im" href="https://www.instagram.com/iclfincorp/" title="Instagram" target="_blank"><i class="fa-brands fa-instagram"></i></a>
                <!--<a class="trs tx" href="javascript:void(0)" title="Twitter" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
                <a class="trs in" href="javascript:void(0)" title="Linkedin" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>-->
                <a class="trs yt" href="https://www.youtube.com/channel/UCdG9r8ROaPrKycOtEm8zcHg" title="YouTube" target="_blank"><i class="fa-brands fa-youtube"></i></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="copyright">
    <div class="container">
      <div class="row">
        <div class="col-xxl-8 col-xl-8 col-12 text-xl-start text-center order-xl-1 order-2">
          Copyright <i class="fa-regular fa-copyright"></i> 2023&nbsp;ICL Fincorp Limited. All&nbsp;Rights&nbsp;Reserved. Developed&nbsp;by <a class="trs" href="https://gingertechnologies.in/" target="_blank">Ginger&nbsp;Technologies</a>.
        </div>
        <div class="col-xxl-4 col-xl-4 col-12 text-xl-end text-center mb-xl-0 mb-4 copyright_menu order-xl-2 order-1 d-lg-block d-none">
          <a class="trs me-4" href="javascript:void(0)">Terms &amp; Conditions</a>
          <a class="trs" href="javascript:void(0)">Privacy Policy</a>
        </div>
      </div>
    </div>
  </section>
    <a href="#" id="scroll" style="display: none;">Go&nbsp;To&nbsp;Top<span></span></a>
<!--************************************* common js **********************************-->



    <?php echo $__env->yieldPushContent('custom-js'); ?>
</body>
</html><?php /**PATH D:\Xampp\htdocs\bibin\Ginger\Laravel\ICL-Fincorp\resources\views/website/layouts/app.blade.php ENDPATH**/ ?>